/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptphaser";
declare description "phaser filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.14";
declare license "GPL 3.0 or later";

//link the libraries
ma = library("math.lib");
en = library("envelopes.lib");
ba = library("basics.lib");
si = library("signals.lib");
fi = library("effect.lib");
cptbasics = library("lib/basics.lib");

// constant variables used in this program
constant = environment {
	     nchannels = 2;// number of channels; 1 for mono, 2 for stereo
	     nphases = 2;//number of phases
	   };

// phaser
//nphases in parallel, the glide and echo effect
phaser = _<:(_),(par(i,constant.nphases, (@(ma.SR * phase(i+1)) *glide(i+1)<: echo(constant.nphases+3,phase(i+1) * ma.SR))) :>_

		//divided by number of phases											      
		/ constant.nphases) :
		//mixes 2 channels, lets you set the amount of original signal and phase(s) effect
		cptbasics.mix2chan(_,_,constant.nphases+6)
								    
with {

  //a slider for the phase time in seconds
  phase(n) = hslider("[%n-1]phase %n", 0, 0, 1, 0.001);

  //glide effect
  glide(n) =((glideslider* en.ar(atrt,atrt,pulse(n)),1-glideslider):max) with {
    // a slider for glide effect
    glideslider = hslider("[%n]phase %n glide", 0, 0, 1, 0.01);
    atrt =  ba.samp2sec(ma.SR)*phase(n);
  };

  //feedback, recursive function
  //includes functions for low/highpass function
  echo(n,delay) = +~bounce(delay,feedback) with {
    bounce(delay, feedback) = @(delay) : lowpassf(n+1) :highpassf(n+2) *(feedback);

    //a slider for the feedback factor
    feedback = hslider("[%n]feedback", 0.5,0,1,0.01) : si.smoo;

    //a lowpass function, decreases with step
    lowpassf(n) =  _<:select2(lowpassfactor == 0 ,lowpassfilter,_) with {
      lowpassfilter = fi.lowpass(1, 20000 / (lowpassfactor+1));

      //a slider for the lowpassfactor
      lowpassfactor = hslider("[%n]feedback lowpassfactor",0,0,10,0.1);
    };

    //a highpass function, increases with every step
    highpassf(n) =  _<:select2(highpassfactor == 0,highpassfilter,_) with {
      highpassfilter = fi.highpass(1, 1+(100*highpassfactor) );

      //a slider for the highpassfactor
      highpassfactor = hslider("[%n]feedback highpassfactor",0,0,10,0.1);
    };
  };

  //the pulse for glide and echo
  pulse(n) = select2(phase(n) == 0 ,ba.pulsen(phase(n) * ma.SR+1,2*phase(n)*ma.SR+1),0);

};

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i) :

				     //cptbasics.Ndrywetmonofx(i, phaser) : //for N number of channels
				     
				     cptbasics.stereodrywetmonofx(i, phaser) ://for 2 channels only; enables effect balance slider
     	                             cptbasics.bargraphoutput(i));

