/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptoverdrive";
declare description "overdrive filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.14";
declare license "GPL 3.0 or later";

//link the libraries
an  = library("analyzers.lib");
si = library("signals.lib");
aa = library("aanl.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
  nchannels = 2;// number of channels; 1 for mono, 2 for stereo
};

// a slider for the gain
gain = hslider("[5]gain", 1, 0, 2, 0.01) : si.smoo;

//overdrive
overdrive = _<:((_ * drive : aa.hardclip),_ ) : (_ * _ : an.abs_envelope_tau(0) )
with {

  // a slider for the drive
  drive = hslider("[2]drive[lv2:integer]",20,1,100,1) : si.smoo;
};

     
// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i) :
				     
				     //cptbasics.Ndrywetmonofx(i, (overdrive * gain)) : //for N number of channels
				     
				     cptbasics.stereodrywetmonofx(i,overdrive * gain) : //for 2 channels only; enables effect balance slider
				     

				     cptbasics.bargraphoutput(i) );



