/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptflanger";
declare description "flanger filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.14";
declare license "GPL 3.0 or later";

//link the libraries
si = library("signals.lib");
ma = library("math.lib");
en = library("envelopes.lib");
ba = library("basics.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2;// number of channels; 1 for mono, 2 for stereo
	   };

// the function that decribes the flanger effect
flanger = (( @(ma.SR * delay1 * en.ar(delay1, delay1, pulse1)), 
	   ( @(ma.SR * delay2 * en.ar(delay2, delay2, pulse2))))) :(cptbasics.mix2chan(_,_,3)) 
	  /2
	  
with {

  delay1 = hslider("[1]delay 1", 0, 0, 0.1, 0.001);
  delay2 = hslider("[2]delay 2",0,0,0.1,0.001);

  pulse1 = select2(delay1 == 0,ba.pulsen(delay1*ma.SR+1,2*delay1*ma.SR+1),0);
  pulse2 = select2(delay2 == 0,ba.pulsen(delay2*ma.SR+1,2*delay2*ma.SR+1),0);

};

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par( i, constant.nchannels,cptbasics.bargraphinput(i) :

				     //cptbasics.Ndrywetmonofx(i, flanger ) : //for N number of channels
				     
				     cptbasics.stereodrywetmonofx(i, flanger) ://for 2 channels only; enables effect balance slider
	                             cptbasics.bargraphoutput(i));

