/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <gtkmm/main.h>

#include <bit/tuple.h>
#include <bitgtkmm/buffertable.h>
#include <bitgtkmm/bufferlist.h>
#include <netinet/in.h>

#include <iostream>

uint8_t udp_packet[] =
  {
    // IP Header
    0x45, 0x00, 0x00, 0x2b, 0x1b, 0x45, 0x00, 0x00, 0xff, 0x11, 0x95, 0x6e, 0x0a, 0x05, 0x01, 0x0a, 0xff, 0xff, 0xff, 0xff,
    // UDP Header
    0x04, 0x06, 0x0b, 0xbb, 0x00, 0x17, 0xe4, 0xf0,
    // Data
    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
  };


class MainWindow: public Gtk::Window
  {
  public:
    MainWindow(std::string file, int width):
      m_btninc("Increment"),
      m_btndec("Decrement"),
      m_btnreset("Reset"),
      m_btndata("Load Data"),
      m_adj(0, 0, 0)
    {
      m_index.load_xml(file);
      m_buffer.set_fields(m_index);
      m_buffer.set_data(&udp_packet, sizeof(udp_packet));

      m_table.set_bit_width(width);
      //     m_table.set_index(&m_index);
      m_table.set_buffer(m_buffer);
      Gtk::VBox* vbox = Gtk::manage(new Gtk::VBox());

      m_list.set_buffer(m_buffer);

      m_notebook.append_page(m_table, "Table Layout");
      m_notebook.append_page(m_list, "List View");
      vbox->pack_start(m_notebook);
      vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));
      vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));
      vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));
      vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));
      Gtk::HBox* hbox = Gtk::manage(new Gtk::HBox());
      hbox->pack_start(m_label);

      m_adj.set_upper(1000);
      m_field.configure(m_adj, 1.0, 0);
      m_field.signal_value_changed().connect(sigc::mem_fun(*this, &MainWindow::on_spin_changed));
      on_spin_changed();

      hbox->pack_start(m_field);
      vbox->pack_start(*hbox);

      Gtk::HBox* hbox2 = Gtk::manage(new Gtk::HBox());
      hbox2->pack_start(m_btninc);
      hbox2->pack_start(m_btndec);
      hbox2->pack_start(m_btnreset);
      hbox2->pack_start(m_btndata);
      vbox->pack_start(*hbox2);
      add
        (*vbox);

      m_btninc.signal_clicked().connect(sigc::bind(sigc::mem_fun(*this, &MainWindow::on_clicked), 0));
      m_btndec.signal_clicked().connect(sigc::bind(sigc::mem_fun(*this, &MainWindow::on_clicked), 1));
      m_btnreset.signal_clicked().connect(sigc::bind(sigc::mem_fun(*this, &MainWindow::on_clicked), 2));
      m_btndata.signal_clicked().connect(sigc::bind(sigc::mem_fun(*this, &MainWindow::on_clicked), 3));
//       m_buffer.signal_field_changed().connect(sigc::mem_fun(*this, &MainWindow::on_buffer_changed));
//       m_buffer.signal_field_changed().connect(sigc::mem_fun(*this, &MainWindow::callback1));
//       m_buffer.signal_field_changed().connect(sigc::mem_fun(*this, &MainWindow::callback2));

      show_all_children();
    }

    ~MainWindow()
  { }

  protected:
    bit::Tuple m_index;
    bitgtk::BufferTable m_table;
    bitgtk::BufferList m_list;
    bit::FieldBuffer m_buffer;
    Gtk::Button m_btninc, m_btndec, m_btnreset, m_btndata;
    Gtk::SpinButton m_field;
    Gtk::Label m_label;
    Gtk::Adjustment m_adj;
    Gtk::Notebook m_notebook;

    void on_clicked(int which)
    {
      uint32_t val = 0x00, val2 = 0x00;
      val = m_buffer[0][0];
      val = ntohl(val);
      std::cout << "original value " << val << std::endl;
      switch (which)
        {
        case 0:
          val += 1;
          break;
        case 1:
          val -= 1;
          break;
        case 2:
          val = 0x00;
          break;
         case 3:
           m_buffer.set_data(udp_packet, sizeof(udp_packet));
           return;
           break;
        }
      std::cout << "changed value " << val << std::endl;
      val = htonl(val);
      m_buffer[0][0] = val;
      val2 = m_buffer[0][0];
      val2 = ntohl(val2);
      std::cout << "value check " << val2 << " (should be " << htonl(val) << ")" << std::endl;
    }

    void on_spin_changed()
    {
//       m_label.set_text(m_buffer.index().element(m_field.get_value_as_int()).name());
    }

    void on_buffer_changed(std::string name)
    {
      uint32_t t;
/*      static bool changing = false;
      if (changing)
        {
          changing = false;
          std::cout << "change in process" << std::endl;
          return;
        }
      //       element = m_field.get_value_as_int();
      changing = true;*/
      std::cout << "changed called for " << name << std::endl;
/*      t = m_buffer[name];
      t = ntohl(t);
      t += 3;
      t = htonl(t);*/
    }

    void callback1(std::string name)
    {
      std::cout << "Callback1 for element " << name << std::endl;
    }
    void callback2(std::string name)
    {
      std::cout << "Callback2 for element " << name << std::endl;
    }
  };

int main (int argc, char *argv[])
{
  const char defaultfile[] = "udp.xml";
  const char* file;
  int width = 32;

  if (argc > 1)
    file = argv[1];
  else
    file = defaultfile;

  if (argc > 2)
    width = atoi(argv[2]);

  Gtk::Main kit(argc, argv);

  MainWindow win(file, width);
  Gtk::Main::run(win); //Shows the window and returns when it is closed.

  return 0;
}
