/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <bit/buffer.h>
#include <iostream>
#include <iomanip>
#include <byteswap.h>

using namespace bit;
using namespace std;

void test(std::string desc, uint32_t value, uint32_t expected, size_t offset, size_t extract, size_t destsize);

int passed = 0, failed = 0;

int main() {
  test("partial octet ends on first octet boundary", 0x89ABCDEF, 0x1F345678, 4, 4, 4);
  test("partial octet ends on second octet boundary", 0x89ABCDEF, 0x123F5678, 12, 4, 4);
  test("whole octet ends on first octet boundary", 0x89ABCDEF, 0xEF345678, 0, 8, 8);
  test("whole octet ends on second octet boundary", 0x89ABCDEF, 0x12EF5678, 8, 8, 8);
  test("three bits ends on first octet boundary", 0x89ABCDEF, 0x17345678, 5, 3, 3);
  test("three bits ends on second octet boundary", 0x89ABCDEF, 0x12375678, 13, 3, 3);
  test("two mid octets", 0x89ABCDEF, 0x1CDEF678, 4, 16, 16);
  test("two mid octet bits", 0x89ABCDEF, 0x16345678, 5, 2, 2);
  test("two bits into mid octet", 0x89ABCDEF, 0x0e345678, 2, 4, 2);
  test("spanning octets", 0x89ABCDEF, 0x12BCDEF8, 8, 20, 20);
  test("spanning octets2", 0x89ABCDEF, 0x1ABCDEF8, 4, 24, 24);

  cout << "\n\nSummary: \n"
      << "Total tests: " << passed+failed << endl
      << "Passed:      " << passed << endl
      << "Failed:      " << failed << endl;
  if (failed)
    cout << "WARNING!!! " << failed << " tests failed!\n";
  else
    cout << "No tests failed.\n";
  return failed;
}


void test(std::string desc, uint32_t value, uint32_t expected, size_t offset, size_t destsize, size_t extract) {
  Buffer b;
  uint32_t buf=0x12345678;

  cout << "Test: " << desc << endl;
  cout << setw(25) << "Input value: " << "0x" << setbase(16) << value << endl;
  value = bswap_32(value);
  buf = bswap_32(buf);
  b.set_data(&buf, sizeof(buf));
  b.pack(&value, sizeof(value), offset, destsize, extract);
  value = bswap_32(value);
  buf = *((uint32_t*)b.data());
  buf = bswap_32(buf);
  cout << setw(25) << "Buffer value: " << "0x" << buf << endl;
  cout << setw(25) << "Expected value: " << "0x" << expected << setbase(10) << endl;
  if (buf == expected) {
    cout << setw(25) << "Test passed\n";
    passed++;
  }
  else {
    cout << setw(25) << "Test FAILED!!!\n";
    cout << setw(25) << "Got: " << "0x" << setbase(16) << buf << setbase(10) << endl;
    failed++;
  }
}
