/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <bit/buffer.h>
#include <iostream>
#include <iomanip>
#include <byteswap.h>

using namespace bit;
using namespace std;

void test(std::string desc, uint32_t value, uint32_t expected, size_t offset, size_t bits);

int passed = 0, failed = 0;

int main() {
  test("bits 28 and 29", 0xffffffff, 0xfffffff3, 28, 2);
  test("middle octets", 0xffffffff, 0xff0000ff, 8, 16);
  test("lead bits", 0xffffffff, 0xff0fffff, 8, 4);
  test("trailing bits", 0xffffffff, 0xfff0ffff, 12, 4);
  test("spanning octets", 0xffffffff, 0xf000000f, 4, 24);

  cout << "\n\nSummary: \n"
      << "Total tests: " << passed+failed << endl
      << "Passed:      " << passed << endl
      << "Failed:      " << failed << endl;
  if (failed)
    cout << "WARNING!!! " << failed << " tests failed!\n";
  else
    cout << "No tests failed.\n";
  return failed;
}

void test(std::string desc, uint32_t value, uint32_t expected, size_t offset, size_t bits) {
  Buffer b;

  cout << "Test: Clearing " << desc << endl;
  cout << setw(25) << "Initial value: " << "0x" << setbase(16) << value << endl;
  value = bswap_32(value);
  b.set_data(&value, sizeof(value));
  b.clear_bits(offset, bits);
  value = *((uint32_t*)b.data());
  value = bswap_32(value);
  cout << setw(25) << "Final value: " << "0x" << value << endl;
  cout << setw(25) << "Expected value: " << "0x" << expected << setbase(10) << endl;
  if (value == expected) {
    cout << setw(25) << "Test passed\n";
    passed++;
  }
  else {
    cout << setw(25) << "Test FAILED!!!\n";
    failed++;
  }
}
