/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <bit/buffer.h>
#include <iostream>
#include <iomanip>
#include <byteswap.h>

using namespace bit;
using namespace std;

void test(std::string desc, uint32_t value, uint32_t expected, size_t offset, size_t extract);

int passed = 0, failed = 0;

int main() {
  test("lower bits", 0x12345678, 0x2, 4, 4);
  test("upper bits", 0x12345678, 0x3, 8, 4);
  test("middle octets", 0x12345678, 0x3456, 8, 16);
  test("spanning octets", 0x12345678, 0x234567, 4, 24);
  test("spanning octets", 0x12345678, 0x1234567, 3, 25);
  test("mid octet bits 26-30", 0x12345678, 0xe, 26, 4);

  cout << "\n\nSummary: \n"
      << "Total tests: " << passed+failed << endl
      << "Passed:      " << passed << endl
      << "Failed:      " << failed << endl;
  if (failed)
    cout << "WARNING!!! " << failed << " tests failed!\n";
  else
    cout << "No tests failed.\n";
  return failed;
}

void test(std::string desc, uint32_t value, uint32_t expected, size_t offset, size_t extract) {
  Buffer b;
  uint32_t extracted;

  cout << "Test: " << desc << endl;
  cout << setw(25) << "Buffer value: " << "0x" << setbase(16) << value << endl;
  value = bswap_32(value);
  b.set_data(&value, sizeof(value));
  b.unpack(&extracted, sizeof(uint32_t), offset, extract);
  extracted = bswap_32(extracted);
  cout << setw(25) << "Extracted value: " << "0x" << extracted << endl;
  cout << setw(25) << "Expected value: " << "0x" << expected << setbase(10) << endl;
  if (extracted == expected) {
    cout << setw(25) << "Test passed\n";
    passed++;
  }
  else {
    cout << setw(25) << "Test FAILED!!!\n";
    failed++;
  }
}
