/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef BIT_GTKBUFFERTABLE_H
#define BIT_GTKBUFFERTABLE_H

#include <gtkmm.h>
#include <vector>
#include <map>
#include <bit/fieldbuffer.h>

namespace bitgtk
  {

  /**
  @author Rick L. Vinyard, Jr.
  */
  class BufferTable : public Gtk::HBox
    {
    public:
      BufferTable();

      ~BufferTable();

      void set_index(bit::Tuple& index);

      void set_buffer(bit::FieldBuffer& buffer);

      void set_bit_width(size_t w);

      void enable_tooltips(bool b=true);

      void enable_highlighter(bool b=true);
      void set_bg_color(std::string s);

      void add_color_set(std::string normal_color, std::string highlight_color="yellow");
      void clear_color_sets();

    protected:
      typedef struct FieldBox {
        std::vector<Gtk::Label*> m_field_labels;
        std::vector<Gtk::EventBox*> m_field_event_boxes;
        std::vector<Gtk::Label*> m_value_labels;
        std::vector<Gtk::EventBox*> m_value_event_boxes;
        std::vector<Gtk::VBox*> m_highlight_boxes;
      } FieldBox;
      
      std::map<std::string, FieldBox > m_fieldbox;
      
      bit::FieldBuffer* m_buffer;
      bit::Tuple* m_index;
      std::list<std::pair<Gdk::Color, Gdk::Color> > m_colors;
      Gtk::Tooltips m_tooltips;
      bool m_highlighter_enabled;
      Gdk::Color m_bg_color;

      size_t m_display_bit_width;
      Gtk::Table* m_table;
      Gtk::EventBox m_tablebox;
      Gtk::EventBox m_tableboxouter;

      void on_index_changed();
      void on_buffer_changed(bit::TupleBase& fb);
      void on_buffer_field_changed(std::string name);
      void on_buffer_fields_changed();

      void create_table();
      bool on_enter(GdkEventCrossing*, std::string name);
      bool on_leave(GdkEventCrossing*, std::string name);

      void create_fieldboxes(bit::TupleBase& fb);
      void add_fieldbox(std::string name, unsigned left, unsigned right, unsigned top, unsigned bottom, Gdk::Color bg, Gdk::Color hl);

    };

}

#endif
