/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef BITGTKBUFFERLIST_H
#define BITGTKBUFFERLIST_H

#include <gtkmm.h>
#include <map>

#include <bit/fieldbuffer.h>

namespace bitgtk
  {

  /**
  @author Rick L. Vinyard, Jr.
  */
  class BufferList : public Gtk::EventBox
    {
    public:
      BufferList();

      ~BufferList();

      void set_buffer(bit::FieldBuffer& buffer);

      void enable_tooltips(bool b=true);

    protected:
      bit::FieldBuffer* m_buffer;
      Gtk::Table* m_table;
      std::map< std::string, Gtk::Label*> m_label;
      Gtk::Tooltips m_tooltips;

      void on_buffer_changed();
      void on_buffer_field_changed(std::string name);
      void on_buffer_fields_changed();
      int create_label(bit::TupleBase& fb, unsigned row);

      void create_table();

    };

}

#endif
