/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef BITTUPLEBASE_H
#define BITTUPLEBASE_H

#include <boost/shared_ptr.hpp>
#include <sigc++/sigc++.h>
#include <string>

namespace bit
  {

  /**
  @author Rick L. Vinyard, Jr.
  */
  class TupleBase: public sigc::trackable
    {
    public:
      class iterator
        {
        public:
          iterator();
          iterator(TupleBase& fb);

          iterator& operator++();
          iterator operator++(int);
          bool operator==(const iterator& other);
          bool operator!=(const iterator& other);
          TupleBase& operator*();
          TupleBase* operator->();

          friend class TupleBase;

        protected:
          TupleBase* next(TupleBase* parent, size_t id);
          TupleBase* prev(TupleBase* parent, size_t id);
          TupleBase& first_child(TupleBase& fb);
          TupleBase& last_child(TupleBase& fb);

          TupleBase* m_tuplebase;
        };


      TupleBase(size_t id=0, size_t offset=0, size_t bits=0);

      TupleBase(TupleBase& parent, size_t id=0, size_t offset=0, size_t bits=0);

      ~TupleBase();

      virtual size_t id() const;

      virtual void set_offset(const size_t& value);
      virtual size_t offset();

      virtual size_t start() const;

      virtual void set_bits(const size_t& value);
      virtual size_t bits() const;

      virtual std::string name() const = 0;
      virtual std::string full_name(int depth=-1) const;
      virtual std::string description() const = 0;

      virtual size_t depth() const;

      virtual size_t size() const = 0;

      virtual bool TupleBase::operator<(const TupleBase& other) const;

      virtual TupleBase& operator[](size_t index) = 0;
      virtual TupleBase& operator[](std::string index) = 0;

      virtual std::string get_xml();

      TupleBase* parent();
      void set_parent(TupleBase*);

      iterator begin();
      iterator end();

      friend class Tuple;

    protected:
      TupleBase* m_parent;
      size_t m_id;
      size_t m_offset;
      size_t m_bits;

      virtual void set_id(const size_t& value);

    };

  typedef boost::shared_ptr<TupleBase> sptrTupleBase;

}

#endif
