/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "tuplebase.h"

using namespace bit;

TupleBase::iterator::iterator(): m_tuplebase(NULL)
{ }

TupleBase::iterator::iterator(TupleBase& fb): m_tuplebase(&fb)
{ }

TupleBase::iterator& TupleBase::iterator::operator++()
{
  if (m_tuplebase != NULL)
    m_tuplebase = next(m_tuplebase->parent(), m_tuplebase->id());
  return *this;
}

TupleBase::iterator TupleBase::iterator::operator++(int)
{
  iterator ret = *this;
  if (m_tuplebase != NULL)
    m_tuplebase = next(m_tuplebase->parent(), m_tuplebase->id());
  return ret;
}

bool TupleBase::iterator::operator==(const iterator& other)
{
  return m_tuplebase == other.m_tuplebase;
}
bool TupleBase::iterator::operator!=(const iterator& other)
{
  return m_tuplebase != other.m_tuplebase;
}

TupleBase& TupleBase::iterator::operator*()
{
  return *m_tuplebase;
}
TupleBase* TupleBase::iterator::operator->()
{
  return m_tuplebase;
}

TupleBase* TupleBase::iterator::next(TupleBase* parent, size_t id)
{
  if (m_tuplebase == NULL)
    return NULL;
  if (parent == NULL)
    return NULL;
  if (id+1 < parent->size())
  {
    TupleBase& fb = first_child( parent->operator[](id+1) );
    return &( fb );
  }
  return next(parent->parent(), parent->id());
}

TupleBase* TupleBase::iterator::prev(TupleBase* parent, size_t id)
{
  if (m_tuplebase == NULL)
    return NULL;
  if (parent == NULL)
    return NULL;
  if (id > 0)
  {
    TupleBase& fb = last_child( parent->operator[](id-1) );
    return &( fb );
  }
  return prev(parent->parent(), parent->id());
}

TupleBase& TupleBase::iterator::first_child(TupleBase& fb)
{
  if (fb.size() <= 1)
    return fb;
  return first_child(fb.operator[](0));
}

TupleBase& TupleBase::iterator::last_child(TupleBase& fb)
{
  if (fb.size() <= 1)
    return fb;
  return last_child(fb.operator[](fb.size()-1));
}

TupleBase::TupleBase(size_t id, size_t offset, size_t bits):
    m_parent(NULL),
    m_id(id),
    m_offset(offset),
    m_bits(bits)
{}

TupleBase::TupleBase(TupleBase& parent, size_t id, size_t offset, size_t bits):
    m_parent(&parent),
    m_id(id),
    m_offset(offset),
    m_bits(bits)
{}


TupleBase::~TupleBase()
{}



size_t TupleBase::id() const
  {
    return m_id;
  }


void TupleBase::set_id(const size_t& value)
{
  m_id = value;
}

void TupleBase::set_offset(const size_t& value)
{
  m_offset = value;
}

size_t TupleBase::offset()
{
  return m_offset;
}

size_t TupleBase::start() const
  {
    if (m_parent != NULL)
      return (m_parent->start() + m_offset);
    else
      return m_offset;
  }

size_t TupleBase::bits() const
  {
    return m_bits;
  }

void TupleBase::set_bits(const size_t& value)
{
  m_bits = value;
}

bool TupleBase::operator<(const TupleBase& other) const
  {
    return (start() < other.start());
  }

TupleBase * TupleBase::parent( )
{
  return m_parent;
}

void TupleBase::set_parent( TupleBase * parent)
{
  m_parent = parent;
}

std::string TupleBase::full_name( int depth ) const
  {
    if (m_parent != NULL && depth != 0)
      if (depth > 0)
        return m_parent->full_name(depth-1) + "." + name();
      else
        return m_parent->full_name(depth) + "." + name();
    else
      return name();
  }

size_t TupleBase::depth( ) const
  {
    if (m_parent == NULL)
      return 0;
    else
      return m_parent->depth() + 1;
  }

TupleBase::iterator TupleBase::begin()
{
  if (size() > 1)
    return operator[](0).begin();
  else
    return iterator(*this);
}

TupleBase::iterator TupleBase::end()
{
  return iterator();
}

std::string TupleBase::get_xml( )
{
  return std::string();
}

