/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef BIT_FIELD_H
#define BIT_FIELD_H

#include <string>
#include <vector>

#include <libxml++/libxml++.h>

#include <bit/element.h>

namespace bit
  {

  class Field: public TupleBase
    {
    public:

      Field(unsigned id=0, std::string name="", size_t offset=0, size_t element_bits=0, std::string description="", size_t size=1);

      Field(TupleBase& parent, unsigned id=0, std::string name="", size_t offset=0, size_t element_bits=0, std::string description="", size_t size=1);
      
      Field& operator=(const Field& other);
      virtual TupleBase& operator[](size_t index);
      virtual TupleBase& operator[](std::string index);
      
      size_t read(xmlpp::Element& xml_element, size_t last_position);
      virtual std::string get_xml();

      void set_element_bits(const size_t& value);
      size_t element_bits() const;

      virtual size_t bits() const;

      void set_name(const std::string& value) throw (error::name);
      std::string name() const;

      void set_description(const std::string& value);
      std::string description() const;

      virtual size_t size() const;
      virtual void set_size(const size_t& value);

    protected:
      std::string m_name;
      std::string m_description;
      size_t m_size;
      typedef std::vector<Element> ElementContainer;
      ElementContainer m_elements;

      void set_name_without_bracket_check(std::string value);
    };

  typedef boost::shared_ptr<Field> sptrField;
  
}

#endif
