/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef BITFIELDS_ERROR_H
#define BITFIELDS_ERROR_H

#include <sstream>

#include <bit/error.h>

namespace bit
  {

  /**
   * Base class for all index errors.
   * @author Rick L Vinyard Jr
   * @ingroup errors
   */
  class fields_error: public bit_error
    {
    public:
      fields_error(): bit_error("bit:Index: Unknown error.")
      { }
      fields_error(const std::string s): bit_error(s)
      { }
    }
  ;

  namespace error
    {


    namespace fields
      {

      /**
       * Invalid numeric index identifier
       * @author Rick L Vinyard Jr
       * @ingroup errors
       */
      class invalid_numeric_id: public fields_error
        {
        public:
          invalid_numeric_id(): fields_error("bit:Index: Invalid numeric identifier, element not found.")
          { }
          invalid_numeric_id(unsigned int id): fields_error("bit:Index: Invalid numeric identifier, element not found.")
          {
            std::ostringstream sout;
            sout << "bit:Index: No element with numeric identifier (" << id << ")";
            m_error_string = sout.str();
          }
        }
      ;

      /**
       * Invalid string index identifier
       * @author Rick L Vinyard Jr
       * @ingroup errors
       */
      class invalid_string_id: public fields_error
        {
        public:
          invalid_string_id(): fields_error("bit:Index: Invalid string identifier, element not found.")
          { }
          invalid_string_id(std::string s): fields_error("bit:Index: Invalid numeric identifier, element not found.")
          {
            m_error_string = "bit:Index: No element with string identifier (" + s + ")";
          }
        }
      ;


    }
  }
}
#endif
