/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef BITFIELD_ERROR_H
#define BITFIELD_ERROR_H

#include <sstream>

#include <bit/error.h>

namespace bit
  {

  /**
   * @author Rick L Vinyard Jr
   * @ingroup errors
   */
  class field_error: public bit_error
    {
    public:
      field_error(): bit_error("bit:Field: Unknown error.")
      { }
      field_error(const std::string s): bit_error(s)
      { }
    }
  ;

  namespace error
    {

    namespace field
      {

      /**
       * @author Rick L Vinyard Jr
       * @ingroup errors
       */
      class bad_subscript: public field_error
        {
        public:
          bad_subscript(): field_error("bit:Field: subscript requested does not exist.")
          { }
        }
      ;


    }
  }
}
#endif
