/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "element.h"
#include <sstream>

using namespace bit;

Element::Element(size_t id, size_t offset, size_t bits)
  : TupleBase(id, offset, bits)
{
}

Element::Element(const Element& other)
{
  *this = other;
}

Element::Element(TupleBase& parent, size_t id, size_t offset, size_t bits)
: TupleBase(parent, id, offset, bits)
{
}


Element::~Element()
{
}

TupleBase & Element::operator [ ]( size_t index )
{
  throw error::field::bad_subscript();
}

TupleBase & Element::operator [ ]( std::string index )
{
  throw error::field::bad_subscript();
}

std::string Element::name( ) const
{
  if (m_parent != NULL) {
    if (m_parent->size() <= 1)
      return m_parent->name();
    else {
      std::ostringstream sout;
      sout << m_parent->name() << "[" << m_id << "]";
      return sout.str();
    }
  }
  return std::string();
}

std::string Element::description( ) const
{
  if (m_parent != NULL)
    return m_parent->description();
  return std::string();
}

size_t Element::size( ) const
{
  return 1;
}

