
/* This file is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option) */
/* any later version. */

/* This file is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with GNU Emacs; see the file COPYING.  If not, write to */
/* the Free Software Foundation, Inc., 59 Temple Place - Suite 330, */
/* Boston, MA 02111-1307, USA. */

/* Copyright (C) 2004 Ian Zimmerman */

/* $Id: strndup.c,v 1.2 2004/04/29 22:51:20 summerisle Exp $ */


#include <string.h>
#include <stdlib.h>
#include <sys/types.h>

/* strndup can be a macro ?? */
#ifdef strndup
#undef strndup
#endif

char*
strndup (const char* str, size_t size)
{
  int l;
  char* p;

  l = strlen (str);
  if (l > size) l = size;
  p = malloc (l + 1);
  if (p == NULL) return NULL;
  strncpy (p, str, l);
  p[l] = '\0';
  return p;
}
