
#include "options.h"

#if (defined(HAVE_ARGP_H) && defined(HAVE_ARGP_PARSE))
#include <argp.h>

static struct argp_option options_list[] =
  {
    { "read", 'r', "NAME", 0, "Show name and value of parameter given by NAME", 1 },
    { "no-name", 'n', 0, 0, "With -r: omit name, show only value", 1 },
    { "write", 'w', "'NAME=VALUE'", 0, "Assign VALUE to parameter given by NAME", 1 },
    { "to-file", 't', "FILE", 0, "Write names and values of all parameters to FILE", 2 },
    { "from-file", 'f', "FILE", 0, "Read assignments to parameters from FILE", 2 },
    { "dump", 'd', "FILE", 0, "Binary dump the entire CMOS into FILE", 3 },
    { "undump", 'u', "FILE", 0, "Read a binary dump of the entire CMOS from FILE", 3 },
    { "enumerate", 'e', "NAME", 0, "Show possible values of parameter NAME", 4 },
    { "config", 'C', "FILE", 0, "layout configuration in FILE [probe SMBIOS]", 4 },
    { "probe", 'P', 0, 0, "Probe for version information about the host BIOS", 4 },
    { "hash", 'H', 0, OPTION_HIDDEN, "List MD5 hashes of BIOS versions covered by configuration file", 0 },
    { "directory", 'D', 0, OPTION_HIDDEN, "Print configured directory for token map files", 0 },
    { "force", 'F', 0, 0, "Force use of config file not covering host BIOS", 4 },
    { 0, 0, 0, 0, 0, 0 }
  };

struct argp options_parser =
  {
    options_list,
    parse_options,
    NULL,
    "biosconfig reads or writes fields in the CMOS non-volatile store,""\n"
    "most of which are associated with various functions of the PC""\n"
    "Basic Input/Output System (BIOS).  The fields, their types and""\n"
    "value ranges are specified in a configuration file in the style""\n"
    "of GNUstep.  This format is familiar to users of the WindowMaker""\n"
    "window manager or applets written for it, and is explained""\n"
    "in greater detail in the full Info manual.""\n"
    "\v",
    NULL,
    NULL,
    NULL
  };

#else /* (defined(HAVE_ARGP_H) && defined(HAVE_ARGP_PARSE)) */

const char getopt_options_list[] = 
  "rn:wtfdueCP:H:D:F:";

#endif /* (defined(HAVE_ARGP_H) && defined(HAVE_ARGP_PARSE)) */
