/* This file is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option) */
/* any later version. */

/* This file is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with GNU Emacs; see the file COPYING.  If not, write to */
/* the Free Software Foundation, Inc., 59 Temple Place - Suite 330, */
/* Boston, MA 02111-1307, USA. */

/* Copyright (C) 2004 California Digital Corporation */

/* $Id: layoutlex.h,v 1.2 2004/04/01 23:41:24 itz Exp $ */

#ifndef LAYOUTLEX_H_INCLUDED
#define LAYOUTLEX_H_INCLUDED

#include <stdio.h>

#include "object.h"

union YYSTYPE;

struct input_state
{
  const char* fname;
  int line;
  int column;
  layout_t* result_layout;
  void* tree;
};

typedef struct input_state input_state_t;

extern int yylex (union YYSTYPE*, void*);

extern layout_t* parse_file (const char* fname);

#endif
