
/* This file is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option) */
/* any later version. */

/* This file is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with GNU Emacs; see the file COPYING.  If not, write to */
/* the Free Software Foundation, Inc., 59 Temple Place - Suite 330, */
/* Boston, MA 02111-1307, USA. */

/* Copyright (C) 2004 Ian Zimmerman */

/* $Id: escape.h,v 1.1 2004/04/01 23:41:24 itz Exp $ */

#ifndef ESCAPE_H_INCLUDED
#define ESCAPE_H_INCLUDED

#include <sys/types.h>
#include <stdio.h>

extern int
unescape_char (const char** src, const char* endsrc);

extern char*
unescape_array (char* dst, const char* src, size_t len);

extern ssize_t
file_unescape_array (FILE* fp, const char* src, size_t len);

extern char*
unescape_string (char* dst, const char* src);

extern ssize_t
file_unescape_string (FILE* fp, const char* src);

extern char*
escape_char (char* dst, int c, const char* extras);

extern char*
escape_array (char* dst, const char* src, size_t len, const char* extras);

extern ssize_t
file_escape_array (FILE* fp, const char* src, size_t len, const char* extras);

extern char*
escape_string (char* dst, const char* src, const char* extras);

extern ssize_t
file_escape_string (FILE* fp, const char* src, const char* extras);

#endif
