
/* This file is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option) */
/* any later version. */

/* This file is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with GNU Emacs; see the file COPYING.  If not, write to */
/* the Free Software Foundation, Inc., 59 Temple Place - Suite 330, */
/* Boston, MA 02111-1307, USA. */

/* Copyright (C) 2004 California Digital Corporation */
/* $Id: cmoslow.c,v 1.8 2004/10/25 17:29:54 itz Exp $ */

#include "cmoslow.h"

#include <inttypes.h>
#include <sys/io.h>
#include <time.h>
#include <stdio.h>

/* cmos_read_byte - read a byte from a given offset in the CMOS */
/* address_port = typically 0x70 */
/* data_port = typically 0x71 */
/* address = offset in CMOS to read from */
/* return : byte value read from CMOS  */

uint8_t
cmos_read_byte (uint16_t address_port, uint16_t data_port, uint8_t address)
{
  struct timespec tv;
  uint8_t byte;
  
#ifdef DEBUG_READS
  fprintf (stderr, "outb (0x%02hx, 0x%04hx);\n", (uint16_t)address, address_port);
#endif
  outb (address, address_port);
  tv.tv_sec = 0; tv.tv_nsec = 500000;
  nanosleep (&tv, NULL);
  byte = inb (data_port);
#ifdef DEBUG_READS
  fprintf (stderr, "inb (0x%04hx) == 0x%02hx;\n", data_port, (uint16_t)byte);
#endif
  return byte;
}

/* cmos_write_byte - write a byte to a given offset in the CMOS */
/* address_port = typically 0x70 */
/* data_port = typically 0x71 */
/* address = offset in CMOS to write to */
/* value = byte value to write to CMOS */

void
cmos_write_byte (uint16_t address_port, uint16_t data_port, uint8_t address, uint8_t value)
{
  struct timespec tv;
  
  outb (address, address_port);
  tv.tv_sec = 0; tv.tv_nsec = 500000;
  nanosleep (&tv, NULL);
  outb (value, data_port);
}

/* cmos_fake_write_byte - output C code to write a byte to a given offset in the CMOS */
/* address_port = typically 0x70 */
/* data_port = typically 0x71 */
/* address = offset in CMOS to write to */
/* value = byte value to write to CMOS */

void
cmos_fake_write_byte (uint16_t address_port, uint16_t data_port, uint8_t address, uint8_t value)
{
  printf ("outb (0x%02hx, 0x%04hx);\n", (uint16_t)address, address_port);
  printf ("outb (0x%02hx, 0x%04hx);\n", (uint16_t)value, data_port);
}
