.\"@(#)rpc.mountd.8"
.\"
.\" Copyright (C) 1999 Olaf Kirch <okir@monad.swb.de>
.\" Modified by Paul Clements, 2004.
.\"
.TH rpc.mountd 8 "31 Dec 2009"
.SH NAME
rpc.mountd \- NFS mount daemon
.SH SYNOPSIS
.BI "/usr/sbin/rpc.mountd [" options "]"
.SH DESCRIPTION
The
.B rpc.mountd
daemon implements the server side of the NFS MOUNT protocol,
an NFS side protocol used by NFS version 2 [RFC1094] and NFS version 3 [RFC1813].
.PP
An NFS server maintains a table of local physical file systems
that are accessible to NFS clients.
Each file system in this table is referred to as an
.IR "exported file system" ,
or
.IR export ,
for short.
.PP
Each file system in the export table has an access control list.
.B rpc.mountd
uses these access control lists to determine
whether an NFS client is permitted to access a given file system.
For details on how to manage your NFS server's export table, see the
.BR exports (5)
and
.BR exportfs (8)
man pages.
.SS Mounting exported NFS File Systems
The NFS MOUNT protocol has several procedures.
The most important of these are
MNT (mount an export) and
UMNT (unmount an export).
.PP
A MNT request has two arguments: an explicit argument that
contains the pathname of the root directory of the export to be mounted,
and an implicit argument that is the sender's IP address.
.PP
When receiving a MNT request from an NFS client,
.B rpc.mountd
checks both the pathname and the sender's IP address against its export table.
If the sender is permitted to access the requested export,
.B rpc.mountd
returns an NFS file handle for the export's root directory to the client.
The client can then use the root file handle and NFS LOOKUP requests
to navigate the directory structure of the export.
.SS The rmtab File
The
.B rpc.mountd
daemon registers every successful MNT request by adding an entry to the
.I /var/lib/nfs/rmtab
file.
When receivng a UMNT request from an NFS client,
.B rpc.mountd
simply removes the matching entry from
.IR /var/lib/nfs/rmtab ,
as long as the access control list for that export allows that sender
to access the export.
.PP
Clients can discover the list of file systems an NFS server is
currently exporting, or the list of other clients that have mounted
its exports, by using the
.BR showmount (8)
command.
.BR showmount (8)
uses other procedures in the NFS MOUNT protocol to report information
about the server's exported file systems.
.PP
Note, however, that there is little to guarantee that the contents of
.I /var/lib/nfs/rmtab
are accurate.
A client may continue accessing an export even after invoking UMNT.
If the client reboots without sending a UMNT request, stale entries
remain for that client in
.IR /var/lib/nfs/rmtab .
.SH OPTIONS
.TP
.B \-d kind " or " \-\-debug kind
Turn on debugging. Valid kinds are: all, auth, call, general and parse.
.TP
.B \-F " or " \-\-foreground
Run in foreground (do not daemonize)
.TP
.B \-f " or " \-\-exports-file
This option specifies the exports file, listing the clients that this
server is prepared to serve and parameters to apply to each
such mount (see
.BR exports (5)).
By default, export information is read from
.IR /etc/exports .
.TP
.B \-h " or " \-\-help
Display usage message.
.TP
.B \-o num " or " \-\-descriptors num
Set the limit of the number of open file descriptors to num. The
default is to leave the limit unchanged.
.TP
.B \-N " or " \-\-no-nfs-version
This option can be used to request that
.B rpc.mountd
do not offer certain versions of NFS. The current version of
.B rpc.mountd
can support both NFS version 2 and the newer version 3. If the
NFS kernel module was compiled without support for NFSv3,
.B rpc.mountd
must be invoked with the option
.B "\-\-no-nfs-version 3" .
.TP
.B \-n " or " \-\-no-tcp
Don't advertise TCP for mount.
.TP
.B \-P
Ignored (compatibility with unfsd??).
.TP
.B \-p " or " \-\-port num
Specifies the port number used for RPC listener sockets.
If this option is not specified,
.B rpc.mountd
chooses a random ephemeral port for each listener socket.
.IP
This option can be used to fix the port value of
.BR rpc.mountd 's
listeners when NFS MOUNT requests must traverse a firewall
between clients and servers.
.TP
.B \-H " or " \-\-ha-callout prog
Specify a high availability callout program.
This program receives callouts for all MOUNT and UNMOUNT requests.
This allows
.B rpc.mountd
to be used in a High Availability NFS (HA-NFS) environment.
.IP
The callout program is run with 4 arguments.
The first is
.B mount
or
.B unmount
depending on the reason for the callout.
The second will be the name of the client performing the mount.
The third will be the path that the client is mounting.
The last is the number of concurrent mounts that we believe the client
has of that path.
.IP
This callout is not needed with 2.6 and later kernels.
Instead, mount the nfsd filesystem on
.IR /proc/fs/nfsd .
.TP
.BI "\-s," "" " \-\-state\-directory\-path "  directory
Specify a directory in which to place statd state information.
If this option is not specified the default of
.I /var/lib/nfs
is used.
.TP
.BI "\-r," "" " \-\-reverse\-lookup"
.B rpc.mountd
tracks IP addresses in the
.I rmtab
file.  When a DUMP request is made (by
someone running
.BR "showmount -a" ,
for instance), it returns IP addresses instead
of hostnames by default. This option causes
.B rpc.mountd
to perform a reverse lookup on each IP address and return that hostname instead.
Enabling this can have a substantial negative effect on performance
in some situations.
.TP
.BR "\-t N" " or " "\-\-num\-threads=N"
This option specifies the number of worker threads that rpc.mountd
spawns.  The default is 1 thread, which is probably enough.  More
threads are usually only needed for NFS servers which need to handle
mount storms of hundreds of NFS mounts in a few seconds, or when
your DNS server is slow or unreliable.
.TP
.B \-V " or " \-\-nfs-version
This option can be used to request that
.B rpc.mountd
offer certain versions of NFS. The current version of
.B rpc.mountd
can support both NFS version 2 and the newer version 3.
.TP
.B \-v " or " \-\-version
Print the version of
.B rpc.mountd
and exit.
.TP
.B \-g " or " \-\-manage-gids
Accept requests from the kernel to map user id numbers into  lists of
group id numbers for use in access control.  An NFS request will
normally (except when using Kerberos or other cryptographic
authentication) contains a user-id and a list of group-ids.  Due to a
limitation in the NFS protocol, at most 16 groups ids can be listed.
If you use the
.B \-g
flag, then the list of group ids received from the client will be
replaced by a list of group ids determined by an appropriate lookup on
the server. Note that the 'primary' group id is not affected so a
.B newgroup
command on the client will still be effective.  This function requires
a Linux Kernel with version at least 2.6.21.
.SH TCP_WRAPPERS SUPPORT
You can protect your
.B rpc.mountd
listeners using the
.B tcp_wrapper
library or
.BR iptables (8).
.PP
Note that the
.B tcp_wrapper
library supports only IPv4 networking.
.PP
Add the hostnames of NFS peers that are allowed to access
.B rpc.mountd
to
.IR /etc/hosts.allow .
Use the daemon name
.B mountd
even if the
.B rpc.mountd
binary has a different name.
.PP
Hostnames used in either access file will be ignored when
they can not be resolved into IP addresses.
For further information see the
.BR tcpd (8)
and
.BR hosts_access (5)
man pages.
.SS IPv6 and TI-RPC support
TI-RPC is a pre-requisite for supporting NFS on IPv6.
If TI-RPC support is built into
.BR rpc.mountd ,
it attempts to start listeners on network transports marked 'visible' in
.IR /etc/netconfig .
As long as at least one network transport listener starts successfully,
.B rpc.mountd
will operate.
.SH FILES
.TP 2.5i
.I /etc/exports
input file for
.BR exportfs ,
listing exports, export options, and access control lists
.TP 2.5i
.I /var/lib/nfs/rmtab
table of clients accessing server's exports
.SH SEE ALSO
.BR exportfs (8),
.BR exports (5),
.BR showmount (8),
.BR rpc.nfsd (8),
.BR rpc.rquotad (8),
.BR nfs (5),
.BR tcpd (8),
.BR hosts_access (5),
.BR iptables (8),
.BR netconfig (5)
.sp
RFC 1094 - "NFS: Network File System Protocol Specification"
.br
RFC 1813 - "NFS Version 3 Protocol Specification"
.SH AUTHOR
Olaf Kirch, H. J. Lu, G. Allan Morris III, and a host of others.
