/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import openlink.util.Vector;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;

class VirtuosoColumn {
    private int typeObject;
    private String name;
    private int typeSQL;
    private int length;
    private int scale;
    private int precision;
    private boolean isAutoIncrement = false;
    private boolean isCaseSensitive = false;
    private boolean isCurrency = false;
    private int isNullable = 1;
    private boolean isSearchable = false;
    private boolean isUpdateable = false;
    private boolean isSigned = false;
    private int _case;
    private boolean _isXml = false;

    VirtuosoColumn(String string, int n, VirtuosoConnection virtuosoConnection) {
        this.name = string;
        this._case = virtuosoConnection.getCase();
        this.typeObject = n;
    }

    VirtuosoColumn(Vector vector, VirtuosoConnection virtuosoConnection) {
        try {
            this.name = virtuosoConnection.charset != null ? virtuosoConnection.uncharsetBytes((String)vector.firstElement()) : (virtuosoConnection.utf8_execs ? new String(((String)vector.firstElement()).getBytes("8859_1"), "UTF8") : (String)vector.firstElement());
            this.typeObject = null != vector.elementAt(1) ? ((Number)vector.elementAt(1)).intValue() : 182;
            if (vector.elementAt(2) != null) {
                this.length = this.scale = ((Number)vector.elementAt(2)).intValue();
            }
            if (vector.elementAt(3) != null) {
                this.precision = ((Number)vector.elementAt(3)).intValue();
            }
            if (vector.elementAt(4) != null && ((Number)vector.elementAt(4)).intValue() == 1) {
                this.isNullable = 1;
            }
            if (vector.elementAt(5) != null && ((Number)vector.elementAt(5)).intValue() == 1) {
                this.isUpdateable = true;
            }
            if (vector.elementAt(6) != null && ((Number)vector.elementAt(6)).intValue() == 1) {
                this.isSearchable = true;
            }
            this._case = virtuosoConnection.getCase();
            if (vector.size() >= 12) {
                int n = ((Number)vector.elementAt(11)).intValue();
                if ((n & 4) != 0) {
                    this._isXml = true;
                }
                if ((n & 2) != 0) {
                    this.isAutoIncrement = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getColumnClassName() throws VirtuosoException {
        if (this._isXml) {
            return "org.w3c.dom.Document";
        }
        return VirtuosoColumn.getColumnClassName(this.typeObject);
    }

    protected static String getColumnClassName(int n) throws VirtuosoException {
        switch (n) {
            case 180: {
                return "java.lang.Void";
            }
            case 181: 
            case 182: 
            case 183: 
            case 186: 
            case 187: 
            case 225: 
            case 226: 
            case 238: {
                return "java.lang.String";
            }
            case 185: {
                return "java.lang.StringBuffer";
            }
            case 184: 
            case 188: {
                return "java.lang.Short";
            }
            case 189: {
                return "java.lang.Integer";
            }
            case 201: {
                return "java.lang.Integer";
            }
            case 190: {
                return "java.lang.Float";
            }
            case 191: {
                return "java.lang.Double";
            }
            case 192: {
                return "java.lang.Character";
            }
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 202: 
            case 209: {
                return "java.util.Vector";
            }
            case 197: 
            case 198: {
                return "java.lang.Object";
            }
            case 125: 
            case 126: 
            case 131: 
            case 222: 
            case 223: {
                return "java.sql.Blob";
            }
            case 219: {
                return "java.lang.BigDecimal";
            }
            case 128: 
            case 129: 
            case 208: 
            case 210: 
            case 211: {
                return "java.lang.Date";
            }
        }
        return "java.lang.Object";
    }

    protected String getColumnName() {
        return this.name;
    }

    protected void setColumnName(String string) {
        this.name = string;
    }

    protected int getColumnDisplaySize() {
        return this.length;
    }

    protected int getColumnType() throws VirtuosoException {
        return VirtuosoColumn.getColumnType(this.typeObject);
    }

    protected static int getColumnType(int n) throws VirtuosoException {
        switch (n) {
            case 184: 
            case 188: {
                return 5;
            }
            case 189: 
            case 201: {
                return 4;
            }
            case 191: {
                return 8;
            }
            case 219: {
                return 2;
            }
            case 190: {
                return 7;
            }
            case 125: {
                return -1;
            }
            case 131: {
                return -4;
            }
            case 132: {
                return -10;
            }
            case 129: {
                return 91;
            }
            case 128: 
            case 208: 
            case 211: {
                return 93;
            }
            case 210: {
                return 92;
            }
            case 222: 
            case 223: {
                return -3;
            }
            case 225: 
            case 226: {
                return -9;
            }
            case 180: 
            case 204: {
                return 0;
            }
            case 181: 
            case 182: 
            case 183: 
            case 186: 
            case 187: 
            case 238: {
                return 12;
            }
            case 185: {
                return -1;
            }
            case 192: {
                return 1;
            }
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 202: 
            case 209: {
                return 2003;
            }
            case 197: 
            case 198: {
                return 1111;
            }
            case 126: 
            case 133: {
                return 2004;
            }
        }
        return 1111;
    }

    protected int getPrecision() {
        return this.precision;
    }

    protected int getScale() {
        return this.scale;
    }

    protected boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    protected boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    protected boolean isCurrency() {
        return this.isCurrency;
    }

    protected int isNullable() {
        return this.isNullable;
    }

    protected boolean isSearchable() {
        return this.isSearchable;
    }

    protected boolean isSigned() {
        return this.isSigned;
    }

    protected boolean isUpdateable() {
        return this.isUpdateable;
    }

    public int hashCode() {
        if (this.name != null && this._case == 2) {
            return this.name.toUpperCase().hashCode();
        }
        if (this.name != null) {
            return this.name.hashCode();
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof VirtuosoColumn) {
            if (this.name != null && this._case == 2) {
                return ((VirtuosoColumn)object).name.toUpperCase().equals(this.name.toUpperCase());
            }
            if (this.name != null) {
                return ((VirtuosoColumn)object).name.equals(this.name);
            }
        }
        return false;
    }

    protected int getDtp() {
        return this.typeObject;
    }

    protected boolean isXml() {
        return this._isXml;
    }
}

