/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.os.SystemClock;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Searcher {
    private final ViewFetcher viewFetcher;
    private final Scroller scroller;
    private final Sleeper sleeper;
    private final int TIMEOUT = 5000;
    private final String LOG_TAG = "Robotium";
    Set<TextView> uniqueTextViews;
    private int numberOfUniqueViews;

    public Searcher(ViewFetcher viewFetcher, Scroller scroller, Sleeper sleeper) {
        this.viewFetcher = viewFetcher;
        this.scroller = scroller;
        this.sleeper = sleeper;
        this.uniqueTextViews = new HashSet<TextView>();
    }

    public boolean searchWithTimeoutFor(Class<? extends TextView> viewClass, String regex, int expectedMinimumNumberOfMatches, boolean scroll, boolean onlyVisible) {
        long endTime = SystemClock.uptimeMillis() + 5000L;
        while (SystemClock.uptimeMillis() < endTime) {
            this.sleeper.sleep();
            boolean foundAnyMatchingView = this.searchFor(viewClass, regex, expectedMinimumNumberOfMatches, scroll, onlyVisible);
            if (!foundAnyMatchingView) continue;
            return true;
        }
        return false;
    }

    public <T extends TextView> boolean searchFor(final Class<T> viewClass, String regex, int expectedMinimumNumberOfMatches, boolean scroll, final boolean onlyVisible) {
        Callable viewFetcherCallback = new Callable<Collection<T>>(){

            @Override
            public Collection<T> call() throws Exception {
                Searcher.this.sleeper.sleep();
                if (onlyVisible) {
                    return RobotiumUtils.removeInvisibleViews(Searcher.this.viewFetcher.getCurrentViews(viewClass));
                }
                return Searcher.this.viewFetcher.getCurrentViews(viewClass);
            }
        };
        try {
            return this.searchFor(viewFetcherCallback, regex, expectedMinimumNumberOfMatches, scroll);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends View> boolean searchFor(Set<T> uniqueViews, Class<T> viewClass, int index) {
        ArrayList<T> allViews = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getCurrentViews(viewClass));
        int uniqueViewsFound = this.getNumberOfUniqueViews(uniqueViews, allViews);
        if (uniqueViewsFound > 0 && index < uniqueViewsFound) {
            return this.setArrayToNullAndReturn(true, allViews);
        }
        if (uniqueViewsFound > 0 && index == 0) {
            return this.setArrayToNullAndReturn(true, allViews);
        }
        return this.setArrayToNullAndReturn(false, allViews);
    }

    private <T extends View> boolean setArrayToNullAndReturn(boolean booleanToReturn, ArrayList<T> views) {
        views = null;
        return booleanToReturn;
    }

    public <T extends View> boolean searchFor(View view) {
        ArrayList<View> views = this.viewFetcher.getAllViews(true);
        for (View v : views) {
            if (!v.equals(view)) continue;
            return true;
        }
        return false;
    }

    public <T extends TextView> boolean searchFor(Callable<Collection<T>> viewFetcherCallback, String regex, int expectedMinimumNumberOfMatches, boolean scroll) throws Exception {
        if (expectedMinimumNumberOfMatches < 1) {
            expectedMinimumNumberOfMatches = 1;
        }
        while (true) {
            Collection<T> views = viewFetcherCallback.call();
            for (TextView view : views) {
                if (RobotiumUtils.checkAndGetMatches(regex, view, this.uniqueTextViews) != expectedMinimumNumberOfMatches) continue;
                this.uniqueTextViews.clear();
                return true;
            }
            if (scroll && !this.scroller.scroll(0)) {
                return this.logMatchesFoundAndReturnFalse(regex);
            }
            if (!scroll) {
                return this.logMatchesFoundAndReturnFalse(regex);
            }
            this.sleeper.sleep();
        }
    }

    public <T extends View> int getNumberOfUniqueViews(Set<T> uniqueViews, ArrayList<T> views) {
        for (int i = 0; i < views.size(); ++i) {
            uniqueViews.add(views.get(i));
        }
        this.numberOfUniqueViews = uniqueViews.size();
        return this.numberOfUniqueViews;
    }

    public int getNumberOfUniqueViews() {
        return this.numberOfUniqueViews;
    }

    private boolean logMatchesFoundAndReturnFalse(String regex) {
        if (this.uniqueTextViews.size() > 0) {
            Log.d((String)"Robotium", (String)(" There are only " + this.uniqueTextViews.size() + " matches of " + regex));
        }
        this.uniqueTextViews.clear();
        return false;
    }
}

