
use builtin;
use str;

set edit:completion:arg-completer[onefetch] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'onefetch'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'onefetch'= {
            cand -d 'Allows you to disable FIELD(s) from appearing in the output'
            cand --disabled-fields 'Allows you to disable FIELD(s) from appearing in the output'
            cand --number-of-authors 'Maximum NUM of authors to be shown'
            cand --number-of-languages 'Maximum NUM of languages to be shown'
            cand --number-of-file-churns 'Maximum NUM of file churns to be shown'
            cand --churn-pool-size 'Minimum NUM of commits from HEAD used to compute the churn summary'
            cand -e 'Ignore all files & directories matching EXCLUDE'
            cand --exclude 'Ignore all files & directories matching EXCLUDE'
            cand --no-bots 'Exclude [bot] commits. Use <REGEX> to override the default pattern'
            cand -T 'Filters output by language type'
            cand --type 'Filters output by language type'
            cand -t 'Changes the text colors (X X X...)'
            cand --text-colors 'Changes the text colors (X X X...)'
            cand --number-separator 'Which thousands SEPARATOR to use'
            cand --ascii-input 'Takes a non-empty STRING as input to replace the ASCII logo'
            cand -c 'Colors (X X X...) to print the ascii art'
            cand --ascii-colors 'Colors (X X X...) to print the ascii art'
            cand -a 'Which LANGUAGE''s ascii art to print'
            cand --ascii-language 'Which LANGUAGE''s ascii art to print'
            cand --true-color 'Specify when to use true color'
            cand -i 'Path to the IMAGE file'
            cand --image 'Path to the IMAGE file'
            cand --image-protocol 'Which image PROTOCOL to use'
            cand --color-resolution 'VALUE of color resolution to use with SIXEL backend'
            cand -o 'Outputs Onefetch in a specific format'
            cand --output 'Outputs Onefetch in a specific format'
            cand --generate 'If provided, outputs the completion file for given SHELL'
            cand --no-title 'Hides the title'
            cand --no-merges 'Ignores merge commits'
            cand -E 'Show the email address of each author'
            cand --email 'Show the email address of each author'
            cand --http-url 'Display repository URL as HTTP'
            cand --hide-token 'Hide token in repository URL'
            cand --include-hidden 'Count hidden files and directories'
            cand -z 'Use ISO 8601 formatted timestamps'
            cand --iso-time 'Use ISO 8601 formatted timestamps'
            cand --no-bold 'Turns off bold formatting'
            cand --no-color-palette 'Hides the color palette'
            cand --no-art 'Hides the ascii art or image if provided'
            cand --nerd-fonts 'Use Nerd Font icons'
            cand -l 'Prints out supported languages'
            cand --languages 'Prints out supported languages'
            cand -p 'Prints out supported package managers'
            cand --package-managers 'Prints out supported package managers'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
    ]
    $completions[$command]
}
