/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.limewire.util.NetworkUtils;

public class LinuxDnsContextFactory
implements InitialContextFactory {
    private InitialContextFactory delegate;

    public LinuxDnsContextFactory() {
        try {
            this.delegate = (InitialContextFactory)Class.forName("com.sun.jndi.dns.DnsContextFactory").newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        assert (this.delegate != null);
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> hashtable) throws NamingException {
        Context context = this.delegate.getInitialContext(hashtable);
        this.fixContext(context);
        return context;
    }

    private void fixContext(Context context) {
        try {
            Class<?> clazz = context.getClass();
            if (clazz.getName().equals("com.sun.jndi.dns.DnsContext")) {
                Field field = clazz.getDeclaredField("servers");
                field.setAccessible(true);
                String[] stringArray = (String[])field.get(context);
                stringArray = this.filterServers(stringArray);
                field.set(context, stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String[] filterServers(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            try {
                int n = string.indexOf(":");
                if (n != -1) {
                    string = string.substring(0, n);
                }
                if (!NetworkUtils.isDottedIPV4(string)) continue;
                arrayList.add(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList.toArray(new String[0]);
    }
}

