/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.limewire.concurrent.ExecutorsHelper;

public class ThreadExecutor {
    private static final ThreadFactory FACTORY = ExecutorsHelper.daemonThreadFactory("IdleThread");
    private static final ExecutorService THREAD_POOL = ExecutorsHelper.newThreadPool(FACTORY);

    public static Thread newManagedThread(Runnable runnable) {
        return FACTORY.newThread(runnable);
    }

    public static Thread newManagedThread(Runnable runnable, String string) {
        Thread thread = ThreadExecutor.newManagedThread(runnable);
        thread.setName(string);
        return thread;
    }

    public static void startThread(final Runnable runnable, final String string) {
        THREAD_POOL.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.currentThread().setName(string);
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
                }
                finally {
                    Thread.currentThread().setName("IdleThread");
                }
            }
        });
    }
}

