/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.Serializable;
import org.limewire.collection.Interval;
import org.limewire.collection.LongInterval;

public abstract class Range
implements Serializable {
    private static final long serialVersionUID = -2562093104400487223L;
    public static final long MAX_VALUE = 0xFFFFFFFFFFL;

    public final boolean isSubrange(Range range) {
        return this.getLow() >= range.getLow() && this.getHigh() <= range.getHigh();
    }

    public abstract byte[] toBytes();

    public abstract void toBytes(byte[] var1, int var2);

    public abstract long getLow();

    public abstract long getHigh();

    public static Range createRange(long l, long l2) {
        if (l <= Integer.MAX_VALUE && l2 <= Integer.MAX_VALUE) {
            return new Interval(l, l2);
        }
        return new LongInterval(l, l2);
    }

    public static Range createRange(long l) {
        return Range.createRange(l, l);
    }

    public String toString() {
        if (this.getLow() == this.getHigh()) {
            return String.valueOf(this.getLow());
        }
        return String.valueOf(this.getLow()) + "-" + String.valueOf(this.getHigh());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        return this.getLow() == range.getLow() && this.getHigh() == range.getHigh();
    }

    public int hashCode() {
        return (int)(this.getLow() * this.getHigh() % Integer.MAX_VALUE);
    }

    public abstract boolean isLong();
}

