/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import org.limewire.collection.EmptyIterator;
import org.limewire.collection.Trie;

public class PatriciaTrie<K, V>
extends AbstractMap<K, V>
implements Trie<K, V>,
Serializable {
    private static final long serialVersionUID = 110232526181493307L;
    private final TrieEntry<K, V> root = new TrieEntry(null, null, -1);
    private int size = 0;
    private transient int modCount = 0;
    private final KeyAnalyzer<? super K> keyAnalyzer;
    private volatile transient Set<K> keySet = null;
    private volatile transient Collection<V> values = null;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;

    public PatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer) {
        this.keyAnalyzer = keyAnalyzer;
    }

    public KeyAnalyzer<? super K> getKeyAnalyzer() {
        return this.keyAnalyzer;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.keyAnalyzer;
    }

    @Override
    public void clear() {
        ((TrieEntry)this.root).key = null;
        ((TrieEntry)this.root).bitIndex = -1;
        ((TrieEntry)this.root).value = null;
        ((TrieEntry)this.root).parent = null;
        ((TrieEntry)this.root).left = (TrieEntry)this.root;
        ((TrieEntry)this.root).right = null;
        ((TrieEntry)this.root).predecessor = (TrieEntry)this.root;
        this.size = 0;
        this.incrementModCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void incrementSize() {
        ++this.size;
        this.incrementModCount();
    }

    private void decrementSize() {
        --this.size;
        this.incrementModCount();
    }

    private void incrementModCount() {
        ++this.modCount;
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            throw new NullPointerException("Key cannot be null");
        }
        int n = this.length(k);
        if (n == 0) {
            if (this.root.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return (V)((TrieEntry)this.root).setKeyValue(k, v);
        }
        TrieEntry<K, V> trieEntry = this.getNearestEntryForKey(k, n);
        if (k.equals(((TrieEntry)trieEntry).key)) {
            if (trieEntry.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return (V)((TrieEntry)trieEntry).setKeyValue(k, v);
        }
        int n2 = this.bitIndex(k, ((TrieEntry)trieEntry).key);
        if (PatriciaTrie.isValidBitIndex(n2)) {
            TrieEntry trieEntry2 = new TrieEntry(k, v, n2);
            this.addEntry(trieEntry2, n);
            this.incrementSize();
            return null;
        }
        if (PatriciaTrie.isNullBitKey(n2)) {
            if (this.root.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return (V)((TrieEntry)this.root).setKeyValue(k, v);
        }
        if (PatriciaTrie.isEqualBitKey(n2) && trieEntry != this.root) {
            this.incrementModCount();
            return (V)((TrieEntry)trieEntry).setKeyValue(k, v);
        }
        throw new IndexOutOfBoundsException("Failed to put: " + k + " -> " + v + ", " + n2);
    }

    private TrieEntry<K, V> addEntry(TrieEntry<K, V> trieEntry, int n) {
        TrieEntry trieEntry2 = ((TrieEntry)this.root).left;
        TrieEntry trieEntry3 = this.root;
        while (true) {
            if (trieEntry2.bitIndex >= ((TrieEntry)trieEntry).bitIndex || trieEntry2.bitIndex <= trieEntry3.bitIndex) {
                ((TrieEntry)trieEntry).predecessor = (TrieEntry)trieEntry;
                if (!this.isBitSet(((TrieEntry)trieEntry).key, n, ((TrieEntry)trieEntry).bitIndex)) {
                    ((TrieEntry)trieEntry).left = (TrieEntry)trieEntry;
                    ((TrieEntry)trieEntry).right = trieEntry2;
                } else {
                    ((TrieEntry)trieEntry).left = trieEntry2;
                    ((TrieEntry)trieEntry).right = (TrieEntry)trieEntry;
                }
                ((TrieEntry)trieEntry).parent = trieEntry3;
                if (trieEntry2.bitIndex >= ((TrieEntry)trieEntry).bitIndex) {
                    trieEntry2.parent = (TrieEntry)trieEntry;
                }
                if (trieEntry2.bitIndex <= trieEntry3.bitIndex) {
                    trieEntry2.predecessor = (TrieEntry)trieEntry;
                }
                if (trieEntry3 == this.root || !this.isBitSet(((TrieEntry)trieEntry).key, n, trieEntry3.bitIndex)) {
                    trieEntry3.left = (TrieEntry)trieEntry;
                } else {
                    trieEntry3.right = (TrieEntry)trieEntry;
                }
                return trieEntry;
            }
            trieEntry3 = trieEntry2;
            if (!this.isBitSet(((TrieEntry)trieEntry).key, n, trieEntry2.bitIndex)) {
                trieEntry2 = trieEntry2.left;
                continue;
            }
            trieEntry2 = trieEntry2.right;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public V get(Object object) {
        TrieEntry<K, V> trieEntry = this.getEntry(object);
        return trieEntry != null ? (V)trieEntry.getValue() : null;
    }

    TrieEntry<K, V> getEntry(Object object) {
        K k = this.asKey(object);
        if (k == null) {
            return null;
        }
        int n = this.length(k);
        TrieEntry<K, V> trieEntry = this.getNearestEntryForKey(k, n);
        return !trieEntry.isEmpty() && k.equals(((TrieEntry)trieEntry).key) ? trieEntry : null;
    }

    protected final K asKey(Object object) {
        try {
            return (K)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private TrieEntry<K, V> getNearestEntryForKey(K k, int n) {
        TrieEntry trieEntry = ((TrieEntry)this.root).left;
        TrieEntry trieEntry2 = this.root;
        while (trieEntry.bitIndex > trieEntry2.bitIndex) {
            trieEntry2 = trieEntry;
            if (!this.isBitSet(k, n, trieEntry.bitIndex)) {
                trieEntry = trieEntry.left;
                continue;
            }
            trieEntry = trieEntry.right;
        }
        return trieEntry;
    }

    @Override
    public V select(K k) {
        int n = this.length(k);
        TrieEntry[] trieEntryArray = new TrieEntry[1];
        if (!this.selectR(((TrieEntry)this.root).left, -1, k, n, trieEntryArray)) {
            TrieEntry trieEntry = trieEntryArray[0];
            return trieEntry.getValue();
        }
        return null;
    }

    private boolean selectR(TrieEntry<K, V> trieEntry, int n, K k, int n2, TrieEntry<?, ?>[] trieEntryArray) {
        if (((TrieEntry)trieEntry).bitIndex <= n) {
            if (!trieEntry.isEmpty()) {
                trieEntryArray[0] = trieEntry;
                return false;
            }
            return true;
        }
        if (!this.isBitSet(k, n2, ((TrieEntry)trieEntry).bitIndex)) {
            if (this.selectR(((TrieEntry)trieEntry).left, ((TrieEntry)trieEntry).bitIndex, k, n2, trieEntryArray)) {
                return this.selectR(((TrieEntry)trieEntry).right, ((TrieEntry)trieEntry).bitIndex, k, n2, trieEntryArray);
            }
        } else if (this.selectR(((TrieEntry)trieEntry).right, ((TrieEntry)trieEntry).bitIndex, k, n2, trieEntryArray)) {
            return this.selectR(((TrieEntry)trieEntry).left, ((TrieEntry)trieEntry).bitIndex, k, n2, trieEntryArray);
        }
        return false;
    }

    @Override
    public Map.Entry<K, V> select(K k, Trie.Cursor<? super K, ? super V> cursor) {
        int n = this.length(k);
        TrieEntry[] trieEntryArray = new TrieEntry[]{null};
        this.selectR(((TrieEntry)this.root).left, -1, k, n, cursor, trieEntryArray);
        return trieEntryArray[0];
    }

    private boolean selectR(TrieEntry<K, V> trieEntry, int n, K k, int n2, Trie.Cursor<? super K, ? super V> cursor, TrieEntry<?, ?>[] trieEntryArray) {
        if (((TrieEntry)trieEntry).bitIndex <= n) {
            if (!trieEntry.isEmpty()) {
                Trie.Cursor.SelectStatus selectStatus = cursor.select(trieEntry);
                switch (selectStatus) {
                    case REMOVE: {
                        throw new UnsupportedOperationException("cannot remove during select");
                    }
                    case EXIT: {
                        trieEntryArray[0] = trieEntry;
                        return false;
                    }
                    case REMOVE_AND_EXIT: {
                        TrieEntry trieEntry2 = new TrieEntry(trieEntry.getKey(), trieEntry.getValue(), -1);
                        trieEntryArray[0] = trieEntry2;
                        this.removeEntry(trieEntry);
                        return false;
                    }
                }
            }
            return true;
        }
        if (!this.isBitSet(k, n2, ((TrieEntry)trieEntry).bitIndex)) {
            if (this.selectR(((TrieEntry)trieEntry).left, ((TrieEntry)trieEntry).bitIndex, k, n2, cursor, trieEntryArray)) {
                return this.selectR(((TrieEntry)trieEntry).right, ((TrieEntry)trieEntry).bitIndex, k, n2, cursor, trieEntryArray);
            }
        } else if (this.selectR(((TrieEntry)trieEntry).right, ((TrieEntry)trieEntry).bitIndex, k, n2, cursor, trieEntryArray)) {
            return this.selectR(((TrieEntry)trieEntry).left, ((TrieEntry)trieEntry).bitIndex, k, n2, cursor, trieEntryArray);
        }
        return false;
    }

    @Override
    public SortedMap<K, V> getPrefixedBy(K k) {
        return this.getPrefixedByBits(k, 0, this.keyAnalyzer.length(k));
    }

    @Override
    public SortedMap<K, V> getPrefixedBy(K k, int n) {
        return this.getPrefixedByBits(k, 0, n * this.keyAnalyzer.bitsPerElement());
    }

    @Override
    public SortedMap<K, V> getPrefixedBy(K k, int n, int n2) {
        return this.getPrefixedByBits(k, n * this.keyAnalyzer.bitsPerElement(), n2 * this.keyAnalyzer.bitsPerElement());
    }

    @Override
    public SortedMap<K, V> getPrefixedByBits(K k, int n) {
        return this.getPrefixedByBits(k, 0, n);
    }

    private SortedMap<K, V> getPrefixedByBits(K k, int n, int n2) {
        int n3 = n + n2;
        if (n3 > this.length(k)) {
            throw new IllegalArgumentException(n + " + " + n2 + " > " + this.length(k));
        }
        if (n3 == 0) {
            return this;
        }
        return new PrefixSubMap(k, n, n2);
    }

    @Override
    public boolean containsKey(Object object) {
        K k = this.asKey(object);
        if (k == null) {
            return false;
        }
        int n = this.length(k);
        TrieEntry<K, V> trieEntry = this.getNearestEntryForKey(k, n);
        return !trieEntry.isEmpty() && k.equals(((TrieEntry)trieEntry).key);
    }

    @Override
    public boolean containsValue(Object object) {
        for (V v : this.values()) {
            if (!PatriciaTrie.valEquals(v, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object object) {
        K k = this.asKey(object);
        if (k == null) {
            return null;
        }
        int n = this.length(k);
        TrieEntry trieEntry = ((TrieEntry)this.root).left;
        TrieEntry trieEntry2 = this.root;
        while (true) {
            if (trieEntry.bitIndex <= trieEntry2.bitIndex) {
                if (!trieEntry.isEmpty() && k.equals(trieEntry.key)) {
                    return this.removeEntry(trieEntry);
                }
                return null;
            }
            trieEntry2 = trieEntry;
            if (!this.isBitSet(k, n, trieEntry.bitIndex)) {
                trieEntry = trieEntry.left;
                continue;
            }
            trieEntry = trieEntry.right;
        }
    }

    private V removeEntry(TrieEntry<K, V> trieEntry) {
        if (trieEntry != this.root) {
            if (((TrieEntry)trieEntry).isInternalNode()) {
                this.removeInternalEntry(trieEntry);
            } else {
                this.removeExternalEntry(trieEntry);
            }
        }
        this.decrementSize();
        return (V)((TrieEntry)trieEntry).setKeyValue(null, null);
    }

    private void removeExternalEntry(TrieEntry<K, V> trieEntry) {
        TrieEntry trieEntry2;
        if (trieEntry == this.root) {
            throw new IllegalArgumentException("Cannot delete root Entry!");
        }
        if (!((TrieEntry)trieEntry).isExternalNode()) {
            throw new IllegalArgumentException(trieEntry + " is not an external Entry!");
        }
        TrieEntry trieEntry3 = ((TrieEntry)trieEntry).parent;
        TrieEntry trieEntry4 = trieEntry2 = ((TrieEntry)trieEntry).left == trieEntry ? ((TrieEntry)trieEntry).right : ((TrieEntry)trieEntry).left;
        if (trieEntry3.left == trieEntry) {
            trieEntry3.left = trieEntry2;
        } else {
            trieEntry3.right = trieEntry2;
        }
        if (trieEntry2.bitIndex > trieEntry3.bitIndex) {
            trieEntry2.parent = trieEntry3;
        } else {
            trieEntry2.predecessor = trieEntry3;
        }
    }

    private void removeInternalEntry(TrieEntry<K, V> trieEntry) {
        TrieEntry trieEntry2;
        if (trieEntry == this.root) {
            throw new IllegalArgumentException("Cannot delete root Entry!");
        }
        if (!((TrieEntry)trieEntry).isInternalNode()) {
            throw new IllegalArgumentException(trieEntry + " is not an internal Entry!");
        }
        TrieEntry trieEntry3 = ((TrieEntry)trieEntry).predecessor;
        trieEntry3.bitIndex = ((TrieEntry)trieEntry).bitIndex;
        TrieEntry trieEntry4 = trieEntry3.parent;
        TrieEntry trieEntry5 = trieEntry2 = trieEntry3.left == trieEntry ? trieEntry3.right : trieEntry3.left;
        if (trieEntry3.predecessor == trieEntry3 && trieEntry3.parent != trieEntry) {
            trieEntry3.predecessor = trieEntry3.parent;
        }
        if (trieEntry4.left == trieEntry3) {
            trieEntry4.left = trieEntry2;
        } else {
            trieEntry4.right = trieEntry2;
        }
        if (trieEntry2.bitIndex > trieEntry4.bitIndex) {
            trieEntry2.parent = trieEntry4;
        }
        if (((TrieEntry)trieEntry).left.parent == trieEntry) {
            ((TrieEntry)trieEntry).left.parent = trieEntry3;
        }
        if (((TrieEntry)trieEntry).right.parent == trieEntry) {
            ((TrieEntry)trieEntry).right.parent = trieEntry3;
        }
        if (((TrieEntry)trieEntry).parent.left == trieEntry) {
            ((TrieEntry)trieEntry).parent.left = trieEntry3;
        } else {
            ((TrieEntry)trieEntry).parent.right = trieEntry3;
        }
        trieEntry3.parent = ((TrieEntry)trieEntry).parent;
        trieEntry3.left = ((TrieEntry)trieEntry).left;
        trieEntry3.right = ((TrieEntry)trieEntry).right;
        if (this.isValidUplink(trieEntry3.left, trieEntry3)) {
            trieEntry3.left.predecessor = trieEntry3;
        }
        if (this.isValidUplink(trieEntry3.right, trieEntry3)) {
            trieEntry3.right.predecessor = trieEntry3;
        }
    }

    private TrieEntry<K, V> previousEntry(TrieEntry<K, V> trieEntry) {
        if (((TrieEntry)trieEntry).predecessor == null) {
            throw new IllegalArgumentException("must have come from somewhere!");
        }
        if (((TrieEntry)trieEntry).predecessor.right == trieEntry) {
            if (this.isValidUplink(((TrieEntry)trieEntry).predecessor.left, ((TrieEntry)trieEntry).predecessor)) {
                return ((TrieEntry)trieEntry).predecessor.left;
            }
            return this.followRight(((TrieEntry)trieEntry).predecessor.left);
        }
        TrieEntry trieEntry2 = ((TrieEntry)trieEntry).predecessor;
        while (trieEntry2.parent != null && trieEntry2 == trieEntry2.parent.left) {
            trieEntry2 = trieEntry2.parent;
        }
        if (trieEntry2.parent == null) {
            return null;
        }
        if (this.isValidUplink(trieEntry2.parent.left, trieEntry2.parent)) {
            if (trieEntry2.parent.left == this.root) {
                if (this.root.isEmpty()) {
                    return null;
                }
                return this.root;
            }
            return trieEntry2.parent.left;
        }
        return this.followRight(trieEntry2.parent.left);
    }

    private TrieEntry<K, V> nextEntry(TrieEntry<K, V> trieEntry) {
        if (trieEntry == null) {
            return this.firstEntry();
        }
        return this.nextEntryImpl(((TrieEntry)trieEntry).predecessor, trieEntry, null);
    }

    private TrieEntry<K, V> nextEntryInSubtree(TrieEntry<K, V> trieEntry, TrieEntry<K, V> trieEntry2) {
        if (trieEntry == null) {
            return this.firstEntry();
        }
        return this.nextEntryImpl(((TrieEntry)trieEntry).predecessor, trieEntry, trieEntry2);
    }

    private TrieEntry<K, V> nextEntryImpl(TrieEntry<K, V> trieEntry, TrieEntry<K, V> trieEntry2, TrieEntry<K, V> trieEntry3) {
        TrieEntry trieEntry4 = trieEntry;
        if (trieEntry2 == null || trieEntry != ((TrieEntry)trieEntry2).predecessor) {
            while (!trieEntry4.left.isEmpty() && trieEntry2 != trieEntry4.left) {
                if (this.isValidUplink(trieEntry4.left, trieEntry4)) {
                    return trieEntry4.left;
                }
                trieEntry4 = trieEntry4.left;
            }
        }
        if (trieEntry4.isEmpty()) {
            return null;
        }
        if (trieEntry4.right == null) {
            return null;
        }
        if (trieEntry2 != trieEntry4.right) {
            if (this.isValidUplink(trieEntry4.right, trieEntry4)) {
                return trieEntry4.right;
            }
            return this.nextEntryImpl(trieEntry4.right, trieEntry2, trieEntry3);
        }
        while (trieEntry4 == trieEntry4.parent.right) {
            if (trieEntry4 == trieEntry3) {
                return null;
            }
            trieEntry4 = trieEntry4.parent;
        }
        if (trieEntry4 == trieEntry3) {
            return null;
        }
        if (trieEntry4.parent.right == null) {
            return null;
        }
        if (trieEntry2 != trieEntry4.parent.right && this.isValidUplink(trieEntry4.parent.right, trieEntry4.parent)) {
            return trieEntry4.parent.right;
        }
        if (trieEntry4.parent.right == trieEntry4.parent) {
            return null;
        }
        return this.nextEntryImpl(trieEntry4.parent.right, trieEntry2, trieEntry3);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Trie[").append(this.size()).append("]={\n");
        Iterator<Map.Entry<K, V>> iterator = this.newEntryIterator();
        while (iterator.hasNext()) {
            stringBuilder.append("  ").append(iterator.next().toString()).append("\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    @Override
    public Map.Entry<K, V> traverse(Trie.Cursor<? super K, ? super V> cursor) {
        TrieEntry<K, V> trieEntry = this.nextEntry(null);
        while (trieEntry != null) {
            TrieEntry<K, V> trieEntry2 = trieEntry;
            Trie.Cursor.SelectStatus selectStatus = cursor.select(trieEntry2);
            trieEntry = this.nextEntry(trieEntry2);
            switch (selectStatus) {
                case EXIT: {
                    return trieEntry2;
                }
                case REMOVE: {
                    this.removeEntry(trieEntry2);
                    break;
                }
                case REMOVE_AND_EXIT: {
                    TrieEntry trieEntry3 = new TrieEntry(trieEntry2.getKey(), trieEntry2.getValue(), -1);
                    this.removeEntry(trieEntry2);
                    return trieEntry3;
                }
            }
        }
        return null;
    }

    private boolean isValidUplink(TrieEntry<K, V> trieEntry, TrieEntry<K, V> trieEntry2) {
        return trieEntry != null && ((TrieEntry)trieEntry).bitIndex <= ((TrieEntry)trieEntry2).bitIndex && !trieEntry.isEmpty();
    }

    private static boolean isValidBitIndex(int n) {
        return 0 <= n && n <= Integer.MAX_VALUE;
    }

    private static boolean isNullBitKey(int n) {
        return n == -1;
    }

    private static boolean isEqualBitKey(int n) {
        return n == -2;
    }

    private int length(K k) {
        if (k == null) {
            return 0;
        }
        return this.keyAnalyzer.length(k);
    }

    private boolean isBitSet(K k, int n, int n2) {
        if (k == null) {
            return false;
        }
        return this.keyAnalyzer.isBitSet(k, n, n2);
    }

    private int bitIndex(K k, K k2) {
        return this.keyAnalyzer.bitIndex(k, 0, this.length(k), k2, 0, this.length(k2));
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    private static boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    @Override
    private TrieEntry<K, V> firstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.followLeft(this.root);
    }

    private TrieEntry<K, V> followLeft(TrieEntry<K, V> trieEntry) {
        while (true) {
            TrieEntry trieEntry2;
            if ((trieEntry2 = trieEntry.left).isEmpty()) {
                trieEntry2 = trieEntry.right;
            }
            if (trieEntry2.bitIndex <= trieEntry.bitIndex) {
                return trieEntry2;
            }
            trieEntry = trieEntry2;
        }
    }

    @Override
    private TrieEntry<K, V> lastEntry() {
        return this.followRight(((TrieEntry)this.root).left);
    }

    protected TrieEntry<K, V> followRight(TrieEntry<K, V> trieEntry) {
        if (trieEntry.right == null) {
            return null;
        }
        while (trieEntry.right.bitIndex > trieEntry.bitIndex) {
            trieEntry = trieEntry.right;
        }
        return trieEntry.right;
    }

    @Override
    public K firstKey() {
        return this.firstEntry().getKey();
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        return new SubMap(null, k);
    }

    @Override
    public K lastKey() {
        TrieEntry<K, V> trieEntry = this.lastEntry();
        if (trieEntry != null) {
            return trieEntry.getKey();
        }
        return null;
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        return new SubMap(k, k2);
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        return new SubMap(k, null);
    }

    protected TrieEntry<K, V> higherEntry(K k) {
        int n = this.length(k);
        if (n == 0) {
            if (!this.root.isEmpty()) {
                if (this.size() > 1) {
                    return this.nextEntry(this.root);
                }
                return null;
            }
            return this.firstEntry();
        }
        TrieEntry<K, V> trieEntry = this.getNearestEntryForKey(k, n);
        if (k.equals(((TrieEntry)trieEntry).key)) {
            return this.nextEntry(trieEntry);
        }
        int n2 = this.bitIndex(k, ((TrieEntry)trieEntry).key);
        if (PatriciaTrie.isValidBitIndex(n2)) {
            TrieEntry trieEntry2 = new TrieEntry(k, null, n2);
            this.addEntry(trieEntry2, n);
            this.incrementSize();
            TrieEntry trieEntry3 = this.nextEntry(trieEntry2);
            this.removeEntry(trieEntry2);
            this.modCount -= 2;
            return trieEntry3;
        }
        if (PatriciaTrie.isNullBitKey(n2)) {
            if (!this.root.isEmpty()) {
                return this.firstEntry();
            }
            if (this.size() > 1) {
                return this.nextEntry(this.firstEntry());
            }
            return null;
        }
        if (PatriciaTrie.isEqualBitKey(n2)) {
            return this.nextEntry(trieEntry);
        }
        throw new IllegalStateException("invalid lookup: " + k);
    }

    protected TrieEntry<K, V> ceilingEntry(K k) {
        int n = this.length(k);
        if (n == 0) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return this.firstEntry();
        }
        TrieEntry<K, V> trieEntry = this.getNearestEntryForKey(k, n);
        if (k.equals(((TrieEntry)trieEntry).key)) {
            return trieEntry;
        }
        int n2 = this.bitIndex(k, ((TrieEntry)trieEntry).key);
        if (PatriciaTrie.isValidBitIndex(n2)) {
            TrieEntry trieEntry2 = new TrieEntry(k, null, n2);
            this.addEntry(trieEntry2, n);
            this.incrementSize();
            TrieEntry trieEntry3 = this.nextEntry(trieEntry2);
            this.removeEntry(trieEntry2);
            this.modCount -= 2;
            return trieEntry3;
        }
        if (PatriciaTrie.isNullBitKey(n2)) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return this.firstEntry();
        }
        if (PatriciaTrie.isEqualBitKey(n2)) {
            return trieEntry;
        }
        throw new IllegalStateException("invalid lookup: " + k);
    }

    protected TrieEntry<K, V> lowerEntry(K k) {
        int n = this.length(k);
        if (n == 0) {
            return null;
        }
        TrieEntry<K, V> trieEntry = this.getNearestEntryForKey(k, n);
        if (k.equals(((TrieEntry)trieEntry).key)) {
            return this.previousEntry(trieEntry);
        }
        int n2 = this.bitIndex(k, ((TrieEntry)trieEntry).key);
        if (PatriciaTrie.isValidBitIndex(n2)) {
            TrieEntry trieEntry2 = new TrieEntry(k, null, n2);
            this.addEntry(trieEntry2, n);
            this.incrementSize();
            TrieEntry trieEntry3 = this.previousEntry(trieEntry2);
            this.removeEntry(trieEntry2);
            this.modCount -= 2;
            return trieEntry3;
        }
        if (PatriciaTrie.isNullBitKey(n2)) {
            return null;
        }
        if (PatriciaTrie.isEqualBitKey(n2)) {
            return this.previousEntry(trieEntry);
        }
        throw new IllegalStateException("invalid lookup: " + k);
    }

    protected TrieEntry<K, V> floorEntry(K k) {
        int n = this.length(k);
        if (n == 0) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return null;
        }
        TrieEntry<K, V> trieEntry = this.getNearestEntryForKey(k, n);
        if (k.equals(((TrieEntry)trieEntry).key)) {
            return trieEntry;
        }
        int n2 = this.bitIndex(k, ((TrieEntry)trieEntry).key);
        if (PatriciaTrie.isValidBitIndex(n2)) {
            TrieEntry trieEntry2 = new TrieEntry(k, null, n2);
            this.addEntry(trieEntry2, n);
            this.incrementSize();
            TrieEntry trieEntry3 = this.previousEntry(trieEntry2);
            this.removeEntry(trieEntry2);
            this.modCount -= 2;
            return trieEntry3;
        }
        if (PatriciaTrie.isNullBitKey(n2)) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return null;
        }
        if (PatriciaTrie.isEqualBitKey(n2)) {
            return trieEntry;
        }
        throw new IllegalStateException("invalid lookup: " + k);
    }

    private TrieEntry<K, V> subtree(K k, int n, int n2) {
        TrieEntry trieEntry;
        TrieEntry trieEntry2 = ((TrieEntry)this.root).left;
        TrieEntry trieEntry3 = this.root;
        while (trieEntry2.bitIndex > trieEntry3.bitIndex && n2 >= trieEntry2.bitIndex) {
            trieEntry3 = trieEntry2;
            if (!this.isBitSet(k, n2 + n, trieEntry2.bitIndex + n)) {
                trieEntry2 = trieEntry2.left;
                continue;
            }
            trieEntry2 = trieEntry2.right;
        }
        TrieEntry trieEntry4 = trieEntry = trieEntry2.isEmpty() ? trieEntry3 : trieEntry2;
        if (trieEntry.isEmpty()) {
            return null;
        }
        int n3 = n + n2;
        if (trieEntry == this.root && this.length(trieEntry.getKey()) < n3) {
            return null;
        }
        if (this.isBitSet(k, n3, n3) != this.isBitSet(trieEntry.key, this.length(trieEntry.key), n2)) {
            return null;
        }
        int n4 = this.keyAnalyzer.bitIndex(k, n, n2, trieEntry.key, 0, this.length(trieEntry.getKey()));
        if (n4 >= 0 && n4 < n2) {
            return null;
        }
        return trieEntry;
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 4268580791803450065L;
        protected K fromKey;
        protected K toKey;
        protected boolean fromInclusive;
        protected boolean toInclusive;
        private transient Set<Map.Entry<K, V>> entrySet;

        protected SubMap() {
        }

        SubMap(K k, K k2) {
            if (k == null && k2 == null) {
                throw new IllegalArgumentException("must have a from or to!");
            }
            if (k != null && k2 != null && PatriciaTrie.this.keyAnalyzer.compare(k, k2) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = k;
            this.toKey = k2;
            this.fromInclusive = true;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.inRange(object) && PatriciaTrie.this.containsKey(object);
        }

        @Override
        public V remove(Object object) {
            if (!this.inRange(object)) {
                return null;
            }
            return PatriciaTrie.this.remove(object);
        }

        @Override
        public V get(Object object) {
            if (!this.inRange(object)) {
                return null;
            }
            return PatriciaTrie.this.get(object);
        }

        @Override
        public V put(K k, V v) {
            if (!this.inRange(k)) {
                throw new IllegalArgumentException("key out of range");
            }
            return PatriciaTrie.this.put(k, v);
        }

        @Override
        public Comparator<? super K> comparator() {
            return PatriciaTrie.this.keyAnalyzer;
        }

        @Override
        public K firstKey() {
            Object k;
            TrieEntry trieEntry = this.fromKey == null ? PatriciaTrie.this.firstEntry() : (this.fromInclusive ? PatriciaTrie.this.ceilingEntry(this.fromKey) : PatriciaTrie.this.higherEntry(this.fromKey));
            Object k2 = k = trieEntry != null ? (Object)trieEntry.getKey() : null;
            if (trieEntry == null || this.toKey != null && !this.inToRange(k, false)) {
                throw new NoSuchElementException();
            }
            return k;
        }

        @Override
        public K lastKey() {
            Object k;
            TrieEntry trieEntry = this.toKey == null ? PatriciaTrie.this.lastEntry() : (this.toInclusive ? PatriciaTrie.this.floorEntry(this.toKey) : PatriciaTrie.this.lowerEntry(this.toKey));
            Object k2 = k = trieEntry != null ? (Object)trieEntry.getKey() : null;
            if (trieEntry == null || this.fromKey != null && !this.inFromRange(k, false)) {
                throw new NoSuchElementException();
            }
            return k;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = this.newSubMapEntrySet();
            }
            return this.entrySet;
        }

        protected Set<Map.Entry<K, V>> newSubMapEntrySet() {
            return new EntrySetView();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            if (!this.inRange2(k)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(k2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(k, k2);
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            if (!this.inRange2(k)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromKey, k);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            if (!this.inRange2(k)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(k, this.toKey);
        }

        protected boolean inRange(K k) {
            return !(this.fromKey != null && !this.inFromRange(k, false) || this.toKey != null && !this.inToRange(k, false));
        }

        protected boolean inRange2(K k) {
            return !(this.fromKey != null && !this.inFromRange(k, false) || this.toKey != null && !this.inToRange(k, true));
        }

        protected boolean inToRange(K k, boolean bl) {
            int n = PatriciaTrie.this.keyAnalyzer.compare(k, this.toKey);
            if (this.toInclusive || bl) {
                return n <= 0;
            }
            return n < 0;
        }

        protected boolean inFromRange(K k, boolean bl) {
            int n = PatriciaTrie.this.keyAnalyzer.compare(k, this.fromKey);
            if (this.fromInclusive || bl) {
                return n >= 0;
            }
            return n > 0;
        }

        class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            EntrySetView() {
            }

            @Override
            public int size() {
                if (this.size == -1 || this.sizeModCount != PatriciaTrie.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = PatriciaTrie.this.modCount;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        ++this.size;
                        iterator.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (!SubMap.this.inRange(k)) {
                    return false;
                }
                TrieEntry trieEntry = PatriciaTrie.this.getEntry(k);
                return trieEntry != null && PatriciaTrie.valEquals(trieEntry.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (!SubMap.this.inRange(k)) {
                    return false;
                }
                TrieEntry trieEntry = PatriciaTrie.this.getEntry(k);
                if (trieEntry != null && PatriciaTrie.valEquals(trieEntry.getValue(), entry.getValue())) {
                    PatriciaTrie.this.removeEntry(trieEntry);
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new SubMapEntryIterator(SubMap.this.fromKey == null ? PatriciaTrie.this.firstEntry() : PatriciaTrie.this.ceilingEntry(SubMap.this.fromKey), SubMap.this.toKey == null ? null : PatriciaTrie.this.ceilingEntry(SubMap.this.toKey));
            }
        }
    }

    private class PrefixSubMap
    extends SubMap {
        private static final long serialVersionUID = -1736000794623484155L;
        protected final K prefix;
        protected final int offset;
        protected final int length;
        private transient int keyModCount = 0;
        protected int size;

        PrefixSubMap(K k, int n, int n2) {
            this.prefix = k;
            this.offset = n;
            this.length = n2;
            this.fromInclusive = false;
        }

        @Override
        public K firstKey() {
            Object object;
            this.fixup();
            TrieEntry trieEntry = this.fromKey == null ? PatriciaTrie.this.firstEntry() : PatriciaTrie.this.higherEntry(this.fromKey);
            Object object2 = object = trieEntry != null ? trieEntry.getKey() : null;
            if (trieEntry == null || !PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, object)) {
                throw new NoSuchElementException();
            }
            return object;
        }

        @Override
        public K lastKey() {
            Object object;
            this.fixup();
            TrieEntry trieEntry = this.toKey == null ? PatriciaTrie.this.lastEntry() : PatriciaTrie.this.lowerEntry(this.toKey);
            Object object2 = object = trieEntry != null ? trieEntry.getKey() : null;
            if (trieEntry == null || !PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, object)) {
                throw new NoSuchElementException();
            }
            return object;
        }

        @Override
        protected boolean inRange(K k) {
            return PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, k);
        }

        @Override
        protected boolean inRange2(K k) {
            return PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, k);
        }

        @Override
        protected boolean inToRange(K k, boolean bl) {
            return PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, k);
        }

        @Override
        protected boolean inFromRange(K k, boolean bl) {
            return PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, k);
        }

        private void fixup() {
            if (PatriciaTrie.this.modCount != this.keyModCount) {
                Iterator iterator = this.entrySet().iterator();
                this.size = 0;
                TrieEntry trieEntry = null;
                if (iterator.hasNext()) {
                    trieEntry = iterator.next();
                    this.size = 1;
                }
                Object object = this.fromKey = trieEntry == null ? null : (Object)trieEntry.getKey();
                if (this.fromKey != null) {
                    TrieEntry trieEntry2 = PatriciaTrie.this.previousEntry(trieEntry);
                    this.fromKey = trieEntry2 == null ? null : trieEntry2.getKey();
                }
                this.toKey = this.fromKey;
                while (iterator.hasNext()) {
                    ++this.size;
                    trieEntry = iterator.next();
                }
                Object object2 = this.toKey = trieEntry == null ? null : (Object)trieEntry.getKey();
                if (this.toKey != null) {
                    this.toKey = (trieEntry = PatriciaTrie.this.nextEntry(trieEntry)) == null ? null : trieEntry.getKey();
                }
                this.keyModCount = PatriciaTrie.this.modCount;
            }
        }

        @Override
        protected Set<Map.Entry<K, V>> newSubMapEntrySet() {
            return new PrefixEntrySetView();
        }

        /*
         * Signature claims super is org.limewire.collection.PatriciaTrie$SubMap.EntrySetView, not org.limewire.collection.PatriciaTrie$SubMap$EntrySetView - discarding signature.
         */
        private class PrefixEntrySetView
        extends SubMap.EntrySetView {
            private TrieEntry<K, V> prefixStart;
            private int iterModCount = 0;

            private PrefixEntrySetView() {
            }

            @Override
            public int size() {
                PrefixSubMap.this.fixup();
                return PrefixSubMap.this.size;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                if (PatriciaTrie.this.modCount != this.iterModCount) {
                    this.prefixStart = PatriciaTrie.this.subtree(PrefixSubMap.this.prefix, PrefixSubMap.this.offset, PrefixSubMap.this.length);
                    this.iterModCount = PatriciaTrie.this.modCount;
                }
                if (this.prefixStart == null) {
                    return EmptyIterator.emptyIterator();
                }
                if (PrefixSubMap.this.length >= this.prefixStart.bitIndex) {
                    return new SingletonIterator(this.prefixStart);
                }
                return new PrefixEntryIterator(this.prefixStart, PrefixSubMap.this.prefix, PrefixSubMap.this.offset, PrefixSubMap.this.length);
            }
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return PatriciaTrie.this.newValueIterator();
        }

        @Override
        public int size() {
            return PatriciaTrie.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return PatriciaTrie.this.containsValue(object);
        }

        @Override
        public void clear() {
            PatriciaTrie.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (!PatriciaTrie.valEquals(v, object)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return PatriciaTrie.this.newKeyIterator();
        }

        @Override
        public int size() {
            return PatriciaTrie.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return PatriciaTrie.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            int n = this.size();
            PatriciaTrie.this.remove(object);
            return n != this.size();
        }

        @Override
        public void clear() {
            PatriciaTrie.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return PatriciaTrie.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            TrieEntry trieEntry = PatriciaTrie.this.getEntry(((Map.Entry)object).getKey());
            return trieEntry != null && trieEntry.equals(object);
        }

        @Override
        public boolean remove(Object object) {
            int n = this.size();
            PatriciaTrie.this.remove(object);
            return n != this.size();
        }

        @Override
        public int size() {
            return PatriciaTrie.this.size;
        }

        @Override
        public void clear() {
            PatriciaTrie.this.clear();
        }
    }

    private class SubMapEntryIterator
    extends NodeIterator<Map.Entry<K, V>> {
        private final K firstExcludedKey;

        SubMapEntryIterator(TrieEntry<K, V> trieEntry, TrieEntry<K, V> trieEntry2) {
            super(trieEntry);
            this.firstExcludedKey = trieEntry2 == null ? null : trieEntry2.key;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.key != this.firstExcludedKey;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.next == null || this.next.key == this.firstExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    private class PrefixEntryIterator
    extends NodeIterator<Map.Entry<K, V>> {
        protected final K prefix;
        protected final int offset;
        protected final int length;
        protected boolean lastOne;
        protected TrieEntry<K, V> subtree;

        PrefixEntryIterator(TrieEntry<K, V> trieEntry, K k, int n, int n2) {
            this.subtree = trieEntry;
            this.next = PatriciaTrie.this.followLeft(trieEntry);
            this.prefix = k;
            this.offset = n;
            this.length = n2;
        }

        @Override
        public Map.Entry<K, V> next() {
            TrieEntry trieEntry = this.nextEntry();
            if (this.lastOne) {
                this.next = null;
            }
            return trieEntry;
        }

        @Override
        protected TrieEntry<K, V> findNext(TrieEntry<K, V> trieEntry) {
            return PatriciaTrie.this.nextEntryInSubtree(trieEntry, this.subtree);
        }

        @Override
        public void remove() {
            boolean bl = false;
            int n = this.subtree.bitIndex;
            if (this.current == this.subtree) {
                bl = true;
            }
            super.remove();
            if (n != this.subtree.bitIndex || bl) {
                this.subtree = PatriciaTrie.this.subtree(this.prefix, this.offset, this.length);
            }
            if (this.length >= this.subtree.bitIndex) {
                this.lastOne = true;
            }
        }
    }

    private class EntryIterator
    extends NodeIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends NodeIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends NodeIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class NodeIterator<E>
    implements Iterator<E> {
        protected int expectedModCount;
        protected TrieEntry<K, V> next;
        protected TrieEntry<K, V> current;

        protected NodeIterator() {
            this.expectedModCount = PatriciaTrie.this.modCount;
            this.next = PatriciaTrie.this.nextEntry(null);
        }

        protected NodeIterator(TrieEntry<K, V> trieEntry) {
            this.expectedModCount = PatriciaTrie.this.modCount;
            this.next = trieEntry;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        TrieEntry<K, V> nextEntry() {
            if (PatriciaTrie.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            TrieEntry trieEntry = this.next;
            if (trieEntry == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext(trieEntry);
            this.current = trieEntry;
            return trieEntry;
        }

        protected TrieEntry<K, V> findNext(TrieEntry<K, V> trieEntry) {
            return PatriciaTrie.this.nextEntry(trieEntry);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (PatriciaTrie.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            TrieEntry trieEntry = this.current;
            this.current = null;
            PatriciaTrie.this.removeEntry(trieEntry);
            this.expectedModCount = PatriciaTrie.this.modCount;
        }
    }

    private class SingletonIterator
    implements Iterator<Map.Entry<K, V>> {
        private final TrieEntry<K, V> entry;
        private int hit = 0;

        public SingletonIterator(TrieEntry<K, V> trieEntry) {
            this.entry = trieEntry;
        }

        @Override
        public boolean hasNext() {
            return this.hit == 0;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.hit != 0) {
                throw new NoSuchElementException();
            }
            ++this.hit;
            return this.entry;
        }

        @Override
        public void remove() {
            if (this.hit != 1) {
                throw new IllegalStateException();
            }
            ++this.hit;
            PatriciaTrie.this.removeEntry(this.entry);
        }
    }

    public static interface KeyAnalyzer<K>
    extends Comparator<K>,
    Serializable {
        public static final int NULL_BIT_KEY = -1;
        public static final int EQUAL_BIT_KEY = -2;

        public int length(K var1);

        public boolean isBitSet(K var1, int var2, int var3);

        public int bitIndex(K var1, int var2, int var3, K var4, int var5, int var6);

        public int bitsPerElement();

        public boolean isPrefix(K var1, int var2, int var3, K var4);
    }

    private static class TrieEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 4596023148184140013L;
        private K key;
        private V value;
        private int bitIndex;
        private TrieEntry<K, V> parent;
        private TrieEntry<K, V> left;
        private TrieEntry<K, V> right;
        private TrieEntry<K, V> predecessor;

        private TrieEntry(K k, V v, int n) {
            this.key = k;
            this.value = v;
            this.bitIndex = n;
            this.parent = null;
            this.left = this;
            this.right = null;
            this.predecessor = this;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Object v;
                V v2;
                Object k;
                Map.Entry entry = (Map.Entry)object;
                K k2 = this.getKey();
                return (k2 == (k = entry.getKey()) || k2 != null && k2.equals(k)) && ((v2 = this.getValue()) == (v = entry.getValue()) || v2 != null && v2.equals(v));
            }
            return false;
        }

        public boolean isEmpty() {
            return this.key == null;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        private V setKeyValue(K k, V v) {
            this.key = k;
            return this.setValue(v);
        }

        private boolean isInternalNode() {
            return this.left != this && this.right != this;
        }

        private boolean isExternalNode() {
            return !this.isInternalNode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.bitIndex == -1) {
                stringBuilder.append("RootEntry(");
            } else {
                stringBuilder.append("Entry(");
            }
            stringBuilder.append("key=").append(this.getKey()).append(" [").append(this.bitIndex).append("], ");
            stringBuilder.append("value=").append(this.getValue()).append(", ");
            if (this.parent != null) {
                if (this.parent.bitIndex == -1) {
                    stringBuilder.append("parent=").append("ROOT");
                } else {
                    stringBuilder.append("parent=").append(this.parent.getKey()).append(" [").append(this.parent.bitIndex).append("]");
                }
            } else {
                stringBuilder.append("parent=").append("null");
            }
            stringBuilder.append(", ");
            if (this.left != null) {
                if (this.left.bitIndex == -1) {
                    stringBuilder.append("left=").append("ROOT");
                } else {
                    stringBuilder.append("left=").append(this.left.getKey()).append(" [").append(this.left.bitIndex).append("]");
                }
            } else {
                stringBuilder.append("left=").append("null");
            }
            stringBuilder.append(", ");
            if (this.right != null) {
                if (this.right.bitIndex == -1) {
                    stringBuilder.append("right=").append("ROOT");
                } else {
                    stringBuilder.append("right=").append(this.right.getKey()).append(" [").append(this.right.bitIndex).append("]");
                }
            } else {
                stringBuilder.append("right=").append("null");
            }
            stringBuilder.append(", ");
            if (this.predecessor != null) {
                if (this.predecessor.bitIndex == -1) {
                    stringBuilder.append("predecessor=").append("ROOT");
                } else {
                    stringBuilder.append("predecessor=").append(this.predecessor.getKey()).append(" [").append(this.predecessor.bitIndex).append("]");
                }
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }
}

