/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.LibraryDatabase;
import com.frostwire.alexandria.db.LibraryDatabaseEntity;
import com.frostwire.alexandria.db.PlaylistDB;
import com.frostwire.alexandria.db.PlaylistItemDB;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Playlist
extends LibraryDatabaseEntity {
    private int _id;
    private String _name;
    private String _description;
    private boolean deleted;
    private List<PlaylistItem> _items;

    public Playlist(LibraryDatabase libraryDatabase) {
        super(libraryDatabase);
        this._id = -2;
        this._items = Collections.synchronizedList(new LinkedList());
        this.deleted = false;
    }

    public Playlist(LibraryDatabase libraryDatabase, int n, String string, String string2) {
        super(libraryDatabase);
        this._id = n;
        this._name = string;
        this._description = string2;
        this._items = new LinkedList<PlaylistItem>();
        this.deleted = false;
    }

    public boolean isStarred() {
        return this._id == -3;
    }

    public int getId() {
        return this._id;
    }

    public void setId(int n) {
        this._id = n;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public List<PlaylistItem> getItems() {
        return this._items;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public synchronized void save() {
        if (this.db != null) {
            PlaylistDB.save(this.db, this);
        }
    }

    public synchronized void delete() {
        if (this.db != null) {
            PlaylistDB.delete(this.db, this);
            this.deleted = true;
        }
    }

    public synchronized void refresh() {
        if (this.db != null) {
            this._items.clear();
            this._items.addAll(PlaylistItemDB.getPlaylistItems(this.db, this));
        }
    }

    public PlaylistItem newItem(String string, String string2, long l, String string3, String string4, float f, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        return new PlaylistItem(this, -1, string, string2, l, string3, string4, f, string5, string6, string7, string8, string9, string10, string11, string12, bl);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Playlist)) {
            return false;
        }
        Playlist playlist = (Playlist)object;
        return playlist.getId() == this.getId();
    }

    public String toString() {
        return this._name;
    }
}

