/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IcyInputStream
extends FilterInputStream {
    private static final Logger logger = Logger.getLogger("musique");
    private Track track;
    private int metaInt = 0;
    private int bytesRead = 0;

    public static void create(String string, Track track) {
        try {
            InputStream inputStream = IcyInputStream.openStream(string);
            IcyInputStream icyInputStream = new IcyInputStream(new BufferedInputStream(inputStream));
            icyInputStream.setTrack(track);
            icyInputStream.init();
            icyInputStream.close();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Error opening Icy stream: " + iOException.getMessage());
        }
    }

    private static InputStream openStream(String string) throws IOException {
        URL uRL = new URL(string);
        Socket socket = new Socket();
        socket.setSoTimeout(1000);
        socket.connect(new InetSocketAddress(uRL.getHost(), uRL.getPort()), 1000);
        OutputStream outputStream = socket.getOutputStream();
        String string2 = "WinampMPEG/5.09";
        String string3 = "GET / HTTP/1.0\r\nuser-agent: " + string2 + "\r\nIcy-MetaData: 1\r\nConnection: keep-alive\r\n\r\n";
        outputStream.write(string3.getBytes());
        return socket.getInputStream();
    }

    private IcyInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private void setTrack(Track track) {
        this.track = track;
    }

    public String readLine() {
        try {
            int n = this.read();
            StringBuilder stringBuilder = new StringBuilder();
            while (n != 10 && n != 13 && n >= 0) {
                stringBuilder.append((char)n);
                n = this.read();
            }
            if (n == 10 || n == 13) {
                this.read();
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Error reading Icy stream", iOException);
            return null;
        }
    }

    private void init() {
        int n;
        String string = "0";
        logger.fine("Reading SHOUTCast response");
        String string2 = this.readLine();
        if (!string2.equals("ICY 200 OK")) {
            logger.warning("SHOUTCast invalid response: " + string2);
            return;
        }
        while (!(string2 = this.readLine()).isEmpty() && (n = string2.indexOf(":")) != -1) {
            String[] stringArray = new String[]{string2.substring(0, n), string2.substring(n + 1)};
            if (stringArray[0].equals("icy-metaint")) {
                string = stringArray[1];
                continue;
            }
            if (stringArray[0].equals("icy-genre")) {
                this.track.genre = stringArray[1];
                continue;
            }
            if (stringArray[0].equals("icy-name")) {
                this.track.name = stringArray[1];
                continue;
            }
            if (stringArray[0].equals("content-type")) {
                this.track.contentType = stringArray[1];
                continue;
            }
            if (stringArray[0].equals("icy-url")) {
                this.track.url = stringArray[1];
                continue;
            }
            if (!stringArray[0].equals("icy-br")) continue;
            this.track.bitrate = stringArray[1];
        }
        try {
            this.metaInt = Integer.parseInt(string.trim());
            logger.fine("Reading metadata information every " + this.metaInt + " bytes");
        }
        catch (NumberFormatException numberFormatException) {
            this.metaInt = 0;
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.metaInt > 0) {
            n3 = this.metaInt - this.bytesRead;
            if (n3 == 0) {
                int n4 = this.read() * 16;
                if (n4 > 1) {
                    String[] stringArray;
                    byte[] byArray2 = new byte[n4];
                    int n5 = super.read(byArray2, 0, n4);
                    if (n5 != n4) {
                        throw new RuntimeException("WTF");
                    }
                    String string = new String(byArray2, 0, n5, "UTF-8");
                    String string2 = "StreamTitle='";
                    if (string.startsWith(string2) && (stringArray = string.substring(string2.length(), string.indexOf(";") - 1).split(" - ")).length > 0) {
                        if (stringArray.length > 1) {
                            System.out.println("artist " + stringArray[0]);
                            System.out.println("title " + stringArray[1]);
                        } else {
                            System.out.println("title " + stringArray[0]);
                        }
                    }
                }
                this.bytesRead = 0;
            } else if (n3 > 0 && n3 < n2) {
                n2 = n3;
            }
        }
        n3 = super.read(byArray, n, n2);
        this.bytesRead += n3;
        return n3;
    }

    public static final class Track {
        public String url;
        public String genre;
        public String name;
        public String contentType;
        public String bitrate;
    }
}

