/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.apple;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.nio.ByteBuffer;

public class QuicktimeTextSampleEntry
extends SampleEntry {
    public static final String TYPE = "text";
    int displayFlags;
    int textJustification;
    int backgroundR;
    int backgroundG;
    int backgroundB;
    long defaultTextBox;
    long reserved1;
    short fontNumber;
    short fontFace;
    byte reserved2;
    short reserved3;
    int foregroundR = 65535;
    int foregroundG = 65535;
    int foregroundB = 65535;
    String fontName = "";

    public QuicktimeTextSampleEntry() {
        super(TYPE);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this._parseReservedAndDataReferenceIndex(byteBuffer);
        this.displayFlags = byteBuffer.getInt();
        this.textJustification = byteBuffer.getInt();
        this.backgroundR = IsoTypeReader.readUInt16(byteBuffer);
        this.backgroundG = IsoTypeReader.readUInt16(byteBuffer);
        this.backgroundB = IsoTypeReader.readUInt16(byteBuffer);
        this.defaultTextBox = IsoTypeReader.readUInt64(byteBuffer);
        this.reserved1 = IsoTypeReader.readUInt64(byteBuffer);
        this.fontNumber = byteBuffer.getShort();
        this.fontFace = byteBuffer.getShort();
        this.reserved2 = byteBuffer.get();
        this.reserved3 = byteBuffer.getShort();
        this.foregroundR = IsoTypeReader.readUInt16(byteBuffer);
        this.foregroundG = IsoTypeReader.readUInt16(byteBuffer);
        this.foregroundB = IsoTypeReader.readUInt16(byteBuffer);
        if (byteBuffer.remaining() > 0) {
            int n = IsoTypeReader.readUInt8(byteBuffer);
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            this.fontName = new String(byArray);
        } else {
            this.fontName = null;
        }
    }

    @Override
    protected long getContentSize() {
        return 52 + (this.fontName != null ? this.fontName.length() : 0);
    }

    public int getDisplayFlags() {
        return this.displayFlags;
    }

    public void setDisplayFlags(int n) {
        this.displayFlags = n;
    }

    public int getTextJustification() {
        return this.textJustification;
    }

    public void setTextJustification(int n) {
        this.textJustification = n;
    }

    public int getBackgroundR() {
        return this.backgroundR;
    }

    public void setBackgroundR(int n) {
        this.backgroundR = n;
    }

    public int getBackgroundG() {
        return this.backgroundG;
    }

    public void setBackgroundG(int n) {
        this.backgroundG = n;
    }

    public int getBackgroundB() {
        return this.backgroundB;
    }

    public void setBackgroundB(int n) {
        this.backgroundB = n;
    }

    public long getDefaultTextBox() {
        return this.defaultTextBox;
    }

    public void setDefaultTextBox(long l) {
        this.defaultTextBox = l;
    }

    public long getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(long l) {
        this.reserved1 = l;
    }

    public short getFontNumber() {
        return this.fontNumber;
    }

    public void setFontNumber(short s) {
        this.fontNumber = s;
    }

    public short getFontFace() {
        return this.fontFace;
    }

    public void setFontFace(short s) {
        this.fontFace = s;
    }

    public byte getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(byte by) {
        this.reserved2 = by;
    }

    public short getReserved3() {
        return this.reserved3;
    }

    public void setReserved3(short s) {
        this.reserved3 = s;
    }

    public int getForegroundR() {
        return this.foregroundR;
    }

    public void setForegroundR(int n) {
        this.foregroundR = n;
    }

    public int getForegroundG() {
        return this.foregroundG;
    }

    public void setForegroundG(int n) {
        this.foregroundG = n;
    }

    public int getForegroundB() {
        return this.foregroundB;
    }

    public void setForegroundB(int n) {
        this.foregroundB = n;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this._writeReservedAndDataReferenceIndex(byteBuffer);
        byteBuffer.putInt(this.displayFlags);
        byteBuffer.putInt(this.textJustification);
        IsoTypeWriter.writeUInt16(byteBuffer, this.backgroundR);
        IsoTypeWriter.writeUInt16(byteBuffer, this.backgroundG);
        IsoTypeWriter.writeUInt16(byteBuffer, this.backgroundB);
        IsoTypeWriter.writeUInt64(byteBuffer, this.defaultTextBox);
        IsoTypeWriter.writeUInt64(byteBuffer, this.reserved1);
        byteBuffer.putShort(this.fontNumber);
        byteBuffer.putShort(this.fontFace);
        byteBuffer.put(this.reserved2);
        byteBuffer.putShort(this.reserved3);
        IsoTypeWriter.writeUInt16(byteBuffer, this.foregroundR);
        IsoTypeWriter.writeUInt16(byteBuffer, this.foregroundG);
        IsoTypeWriter.writeUInt16(byteBuffer, this.foregroundB);
        if (this.fontName != null) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.fontName.length());
            byteBuffer.put(this.fontName.getBytes());
        }
    }
}

