/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import com.googlecode.mp4parser.h264.read.CAVLCReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class H264TrackImpl
extends AbstractTrack {
    private static final Logger LOG = Logger.getLogger(H264TrackImpl.class.getName());
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox sampleDescriptionBox;
    private ReaderWrapper reader;
    private List<ByteBuffer> samples;
    boolean readSamples = false;
    List<TimeToSampleBox.Entry> stts;
    List<CompositionTimeToSample.Entry> ctts;
    List<SampleDependencyTypeBox.Entry> sdtp;
    List<Integer> stss;
    SeqParameterSet seqParameterSet = null;
    PictureParameterSet pictureParameterSet = null;
    LinkedList<byte[]> seqParameterSetList = new LinkedList();
    LinkedList<byte[]> pictureParameterSetList = new LinkedList();
    private int width;
    private int height;
    private int timescale;
    private int frametick;
    private int currentScSize;
    private int prevScSize;
    private SEIMessage seiMessage;
    int frameNrInGop = 0;
    private boolean determineFrameRate = true;
    private String lang = "und";

    public H264TrackImpl(InputStream inputStream, String string, long l) throws IOException {
        this.lang = string;
        if (l <= 1000L) {
            throw new IllegalArgumentException("Timescale must be specified in milliseconds!");
        }
        this.frametick = 1000;
        this.determineFrameRate = false;
        this.parse(inputStream);
    }

    public H264TrackImpl(InputStream inputStream, String string) throws IOException {
        this.lang = string;
        this.parse(inputStream);
    }

    public H264TrackImpl(InputStream inputStream) throws IOException {
        this.parse(inputStream);
    }

    private void parse(InputStream inputStream) throws IOException {
        this.reader = new ReaderWrapper(inputStream);
        this.stts = new LinkedList<TimeToSampleBox.Entry>();
        this.ctts = new LinkedList<CompositionTimeToSample.Entry>();
        this.sdtp = new LinkedList<SampleDependencyTypeBox.Entry>();
        this.stss = new LinkedList<Integer>();
        this.samples = new LinkedList<ByteBuffer>();
        if (!this.readSamples()) {
            throw new IOException();
        }
        if (!this.readVariables()) {
            throw new IOException();
        }
        this.sampleDescriptionBox = new SampleDescriptionBox();
        VisualSampleEntry visualSampleEntry = new VisualSampleEntry("avc1");
        visualSampleEntry.setDataReferenceIndex(1);
        visualSampleEntry.setDepth(24);
        visualSampleEntry.setFrameCount(1);
        visualSampleEntry.setHorizresolution(72.0);
        visualSampleEntry.setVertresolution(72.0);
        visualSampleEntry.setWidth(this.width);
        visualSampleEntry.setHeight(this.height);
        visualSampleEntry.setCompressorname("AVC Coding");
        AvcConfigurationBox avcConfigurationBox = new AvcConfigurationBox();
        avcConfigurationBox.setSequenceParameterSets(this.seqParameterSetList);
        avcConfigurationBox.setPictureParameterSets(this.pictureParameterSetList);
        avcConfigurationBox.setAvcLevelIndication(this.seqParameterSet.level_idc);
        avcConfigurationBox.setAvcProfileIndication(this.seqParameterSet.profile_idc);
        avcConfigurationBox.setBitDepthLumaMinus8(this.seqParameterSet.bit_depth_luma_minus8);
        avcConfigurationBox.setBitDepthChromaMinus8(this.seqParameterSet.bit_depth_chroma_minus8);
        avcConfigurationBox.setChromaFormat(this.seqParameterSet.chroma_format_idc.getId());
        avcConfigurationBox.setConfigurationVersion(1);
        avcConfigurationBox.setLengthSizeMinusOne(3);
        avcConfigurationBox.setProfileCompatibility(this.seqParameterSetList.get(0)[1]);
        visualSampleEntry.addBox(avcConfigurationBox);
        this.sampleDescriptionBox.addBox(visualSampleEntry);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(this.lang);
        this.trackMetaData.setTimescale(this.timescale);
        this.trackMetaData.setWidth(this.width);
        this.trackMetaData.setHeight(this.height);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.stts;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.ctts;
    }

    @Override
    public long[] getSyncSamples() {
        long[] lArray = new long[this.stss.size()];
        for (int i = 0; i < this.stss.size(); ++i) {
            lArray[i] = this.stss.get(i).intValue();
        }
        return lArray;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sdtp;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "vide";
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.samples;
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return new VideoMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    private boolean readVariables() {
        this.width = (this.seqParameterSet.pic_width_in_mbs_minus1 + 1) * 16;
        int n = 2;
        if (this.seqParameterSet.frame_mbs_only_flag) {
            n = 1;
        }
        this.height = 16 * (this.seqParameterSet.pic_height_in_map_units_minus1 + 1) * n;
        if (this.seqParameterSet.frame_cropping_flag) {
            int n2 = 0;
            if (!this.seqParameterSet.residual_color_transform_flag) {
                n2 = this.seqParameterSet.chroma_format_idc.getId();
            }
            int n3 = 1;
            int n4 = n;
            if (n2 != 0) {
                n3 = this.seqParameterSet.chroma_format_idc.getSubWidth();
                n4 = this.seqParameterSet.chroma_format_idc.getSubHeight() * n;
            }
            this.width -= n3 * (this.seqParameterSet.frame_crop_left_offset + this.seqParameterSet.frame_crop_right_offset);
            this.height -= n4 * (this.seqParameterSet.frame_crop_top_offset + this.seqParameterSet.frame_crop_bottom_offset);
        }
        return true;
    }

    private boolean findNextStartcode() throws IOException {
        int n;
        byte[] byArray = new byte[]{-1, -1, -1, -1};
        while ((n = this.reader.read()) != -1) {
            byArray[0] = byArray[1];
            byArray[1] = byArray[2];
            byArray[2] = byArray[3];
            byArray[3] = (byte)n;
            if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1) {
                this.prevScSize = this.currentScSize;
                this.currentScSize = 4;
                return true;
            }
            if (byArray[0] != 0 || byArray[1] != 0 || byArray[2] != 1) continue;
            this.prevScSize = this.currentScSize;
            this.currentScSize = 3;
            return true;
        }
        return false;
    }

    private boolean readSamples() throws IOException {
        if (this.readSamples) {
            return true;
        }
        this.readSamples = true;
        this.findNextStartcode();
        this.reader.mark();
        long l = this.reader.getPos();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = 0;
        while (this.findNextStartcode()) {
            long l2 = this.reader.getPos();
            int n2 = (int)(l2 - l - (long)this.prevScSize);
            this.reader.reset();
            byte[] byArray = new byte[n2];
            this.reader.read(byArray);
            byte by = byArray[0];
            int n3 = by >> 5 & 3;
            int n4 = by & 0x1F;
            LOG.fine("Found startcode at " + (l - 4L) + " Type: " + n4 + " ref idc: " + n3 + " (size " + n2 + ")");
            NALActions nALActions = this.handleNALUnit(n3, n4, byArray);
            switch (nALActions) {
                case IGNORE: {
                    break;
                }
                case BUFFER: {
                    arrayList.add(byArray);
                    break;
                }
                case STORE: {
                    int n5 = 22;
                    ++n;
                    arrayList.add(byArray);
                    ByteBuffer byteBuffer = this.createSample(arrayList);
                    boolean bl = false;
                    if (n4 == 5) {
                        n5 += 16;
                        bl = true;
                    }
                    ByteArrayInputStream byteArrayInputStream = this.cleanBuffer(arrayList.get(arrayList.size() - 1));
                    SliceHeader sliceHeader = new SliceHeader(byteArrayInputStream, this.seqParameterSet, this.pictureParameterSet, bl);
                    if (sliceHeader.slice_type == SliceHeader.SliceType.B) {
                        n5 += 4;
                    }
                    LOG.fine("Adding sample with size " + byteBuffer.capacity() + " and header " + sliceHeader);
                    arrayList.clear();
                    this.samples.add(byteBuffer);
                    this.stts.add(new TimeToSampleBox.Entry(1L, this.frametick));
                    if (n4 == 5) {
                        this.stss.add(n);
                    }
                    if (this.seiMessage == null || this.seiMessage.n_frames == 0) {
                        this.frameNrInGop = 0;
                    }
                    int n6 = 0;
                    if (this.seiMessage != null && this.seiMessage.clock_timestamp_flag) {
                        n6 = this.seiMessage.n_frames - this.frameNrInGop;
                    } else if (this.seiMessage != null && this.seiMessage.removal_delay_flag) {
                        n6 = this.seiMessage.dpb_removal_delay / 2;
                    }
                    this.ctts.add(new CompositionTimeToSample.Entry(1, n6 * this.frametick));
                    this.sdtp.add(new SampleDependencyTypeBox.Entry(n5));
                    ++this.frameNrInGop;
                    break;
                }
                case END: {
                    return true;
                }
            }
            l = l2;
            this.reader.seek(this.currentScSize);
            this.reader.mark();
        }
        return true;
    }

    private ByteBuffer createSample(List<byte[]> list) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            n += list.get(i).length + 4;
        }
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        for (int i = 0; i < list.size(); ++i) {
            byteBuffer.putInt(list.get(i).length);
            byteBuffer.put(list.get(i));
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    private ByteArrayInputStream cleanBuffer(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            if (byArray[n] == 0 && byArray[n + 1] == 0 && byArray[n + 2] == 3) {
                byArray2[n2] = 0;
                byArray2[n2 + 1] = 0;
                n += 3;
                n2 += 2;
                continue;
            }
            byArray2[n2] = byArray[n];
            ++n;
            ++n2;
        }
        return new ByteArrayInputStream(byArray2, 0, n2);
    }

    private NALActions handleNALUnit(int n, int n2, byte[] byArray) throws IOException {
        NALActions nALActions;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                nALActions = NALActions.STORE;
                break;
            }
            case 6: {
                this.seiMessage = new SEIMessage(this.cleanBuffer(byArray), this.seqParameterSet);
                nALActions = NALActions.BUFFER;
                break;
            }
            case 9: {
                int n3 = byArray[1] >> 5;
                LOG.fine("Access unit delimiter type: " + n3);
                nALActions = NALActions.BUFFER;
                break;
            }
            case 7: {
                if (this.seqParameterSet == null) {
                    ByteArrayInputStream byteArrayInputStream = this.cleanBuffer(byArray);
                    byteArrayInputStream.read();
                    this.seqParameterSet = SeqParameterSet.read(byteArrayInputStream);
                    this.seqParameterSetList.add(byArray);
                    this.configureFramerate();
                }
                nALActions = NALActions.IGNORE;
                break;
            }
            case 8: {
                if (this.pictureParameterSet == null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    byteArrayInputStream.read();
                    this.pictureParameterSet = PictureParameterSet.read(byteArrayInputStream);
                    this.pictureParameterSetList.add(byArray);
                }
                nALActions = NALActions.IGNORE;
                break;
            }
            case 10: 
            case 11: {
                nALActions = NALActions.END;
                break;
            }
            default: {
                System.err.println("Unknown NAL unit type: " + n2);
                nALActions = NALActions.IGNORE;
            }
        }
        return nALActions;
    }

    private void configureFramerate() {
        if (this.determineFrameRate) {
            if (this.seqParameterSet.vuiParams != null) {
                this.timescale = this.seqParameterSet.vuiParams.time_scale >> 1;
                this.frametick = this.seqParameterSet.vuiParams.num_units_in_tick;
                if (this.timescale == 0 || this.frametick == 0) {
                    System.err.println("Warning: vuiParams contain invalid values: time_scale: " + this.timescale + " and frame_tick: " + this.frametick + ". Setting frame rate to 25fps");
                    this.timescale = 90000;
                    this.frametick = 3600;
                }
            } else {
                System.err.println("Warning: Can't determine frame rate. Guessing 25 fps");
                this.timescale = 90000;
                this.frametick = 3600;
            }
        }
    }

    public void printAccessUnitDelimiter(byte[] byArray) {
        LOG.fine("Access unit delimiter: " + (byArray[1] >> 5));
    }

    public class SEIMessage {
        int payloadType = 0;
        int payloadSize = 0;
        boolean removal_delay_flag;
        int cpb_removal_delay;
        int dpb_removal_delay;
        boolean clock_timestamp_flag;
        int pic_struct;
        int ct_type;
        int nuit_field_based_flag;
        int counting_type;
        int full_timestamp_flag;
        int discontinuity_flag;
        int cnt_dropped_flag;
        int n_frames;
        int seconds_value;
        int minutes_value;
        int hours_value;
        int time_offset_length;
        int time_offset;
        SeqParameterSet sps;

        public SEIMessage(InputStream inputStream, SeqParameterSet seqParameterSet) throws IOException {
            this.sps = seqParameterSet;
            inputStream.read();
            int n = inputStream.available();
            int n2 = 0;
            while (n2 < n) {
                this.payloadType = 0;
                this.payloadSize = 0;
                int n3 = inputStream.read();
                ++n2;
                while (n3 == 255) {
                    this.payloadType += n3;
                    n3 = inputStream.read();
                    ++n2;
                }
                this.payloadType += n3;
                int n4 = inputStream.read();
                ++n2;
                while (n4 == 255) {
                    this.payloadSize += n4;
                    n4 = inputStream.read();
                    ++n2;
                }
                this.payloadSize += n4;
                if (n - n2 >= this.payloadSize) {
                    if (this.payloadType == 1) {
                        if (seqParameterSet.vuiParams != null && (seqParameterSet.vuiParams.nalHRDParams != null || seqParameterSet.vuiParams.vclHRDParams != null || seqParameterSet.vuiParams.pic_struct_present_flag)) {
                            byte[] byArray = new byte[this.payloadSize];
                            inputStream.read(byArray);
                            n2 += this.payloadSize;
                            CAVLCReader cAVLCReader = new CAVLCReader(new ByteArrayInputStream(byArray));
                            if (seqParameterSet.vuiParams.nalHRDParams != null || seqParameterSet.vuiParams.vclHRDParams != null) {
                                this.removal_delay_flag = true;
                                this.cpb_removal_delay = cAVLCReader.readU(seqParameterSet.vuiParams.nalHRDParams.cpb_removal_delay_length_minus1 + 1, "SEI: cpb_removal_delay");
                                this.dpb_removal_delay = cAVLCReader.readU(seqParameterSet.vuiParams.nalHRDParams.dpb_output_delay_length_minus1 + 1, "SEI: dpb_removal_delay");
                            } else {
                                this.removal_delay_flag = false;
                            }
                            if (seqParameterSet.vuiParams.pic_struct_present_flag) {
                                int n5;
                                this.pic_struct = cAVLCReader.readU(4, "SEI: pic_struct");
                                switch (this.pic_struct) {
                                    default: {
                                        n5 = 1;
                                        break;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 7: {
                                        n5 = 2;
                                        break;
                                    }
                                    case 5: 
                                    case 6: 
                                    case 8: {
                                        n5 = 3;
                                    }
                                }
                                for (int i = 0; i < n5; ++i) {
                                    this.clock_timestamp_flag = cAVLCReader.readBool("pic_timing SEI: clock_timestamp_flag[" + i + "]");
                                    if (!this.clock_timestamp_flag) continue;
                                    this.ct_type = cAVLCReader.readU(2, "pic_timing SEI: ct_type");
                                    this.nuit_field_based_flag = cAVLCReader.readU(1, "pic_timing SEI: nuit_field_based_flag");
                                    this.counting_type = cAVLCReader.readU(5, "pic_timing SEI: counting_type");
                                    this.full_timestamp_flag = cAVLCReader.readU(1, "pic_timing SEI: full_timestamp_flag");
                                    this.discontinuity_flag = cAVLCReader.readU(1, "pic_timing SEI: discontinuity_flag");
                                    this.cnt_dropped_flag = cAVLCReader.readU(1, "pic_timing SEI: cnt_dropped_flag");
                                    this.n_frames = cAVLCReader.readU(8, "pic_timing SEI: n_frames");
                                    if (this.full_timestamp_flag == 1) {
                                        this.seconds_value = cAVLCReader.readU(6, "pic_timing SEI: seconds_value");
                                        this.minutes_value = cAVLCReader.readU(6, "pic_timing SEI: minutes_value");
                                        this.hours_value = cAVLCReader.readU(5, "pic_timing SEI: hours_value");
                                    } else if (cAVLCReader.readBool("pic_timing SEI: seconds_flag")) {
                                        this.seconds_value = cAVLCReader.readU(6, "pic_timing SEI: seconds_value");
                                        if (cAVLCReader.readBool("pic_timing SEI: minutes_flag")) {
                                            this.minutes_value = cAVLCReader.readU(6, "pic_timing SEI: minutes_value");
                                            if (cAVLCReader.readBool("pic_timing SEI: hours_flag")) {
                                                this.hours_value = cAVLCReader.readU(5, "pic_timing SEI: hours_value");
                                            }
                                        }
                                    }
                                    this.time_offset_length = seqParameterSet.vuiParams.nalHRDParams != null ? seqParameterSet.vuiParams.nalHRDParams.time_offset_length : (seqParameterSet.vuiParams.vclHRDParams != null ? seqParameterSet.vuiParams.vclHRDParams.time_offset_length : 24);
                                    this.time_offset = cAVLCReader.readU(24, "pic_timing SEI: time_offset");
                                }
                            }
                        } else {
                            for (int i = 0; i < this.payloadSize; ++i) {
                                inputStream.read();
                                ++n2;
                            }
                        }
                    } else {
                        for (int i = 0; i < this.payloadSize; ++i) {
                            inputStream.read();
                            ++n2;
                        }
                    }
                } else {
                    n2 = n;
                }
                LOG.fine(this.toString());
            }
        }

        public String toString() {
            String string = "SEIMessage{payloadType=" + this.payloadType + ", payloadSize=" + this.payloadSize;
            if (this.payloadType == 1) {
                if (this.sps.vuiParams.nalHRDParams != null || this.sps.vuiParams.vclHRDParams != null) {
                    string = string + ", cpb_removal_delay=" + this.cpb_removal_delay + ", dpb_removal_delay=" + this.dpb_removal_delay;
                }
                if (this.sps.vuiParams.pic_struct_present_flag) {
                    string = string + ", pic_struct=" + this.pic_struct;
                    if (this.clock_timestamp_flag) {
                        string = string + ", ct_type=" + this.ct_type + ", nuit_field_based_flag=" + this.nuit_field_based_flag + ", counting_type=" + this.counting_type + ", full_timestamp_flag=" + this.full_timestamp_flag + ", discontinuity_flag=" + this.discontinuity_flag + ", cnt_dropped_flag=" + this.cnt_dropped_flag + ", n_frames=" + this.n_frames + ", seconds_value=" + this.seconds_value + ", minutes_value=" + this.minutes_value + ", hours_value=" + this.hours_value + ", time_offset_length=" + this.time_offset_length + ", time_offset=" + this.time_offset;
                    }
                }
            }
            string = string + '}';
            return string;
        }
    }

    private class ReaderWrapper {
        private InputStream inputStream;
        private long pos = 0L;
        private long markPos = 0L;

        private ReaderWrapper(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        int read() throws IOException {
            ++this.pos;
            return this.inputStream.read();
        }

        long read(byte[] byArray) throws IOException {
            long l = this.inputStream.read(byArray);
            this.pos += l;
            return l;
        }

        long seek(int n) throws IOException {
            long l = this.inputStream.skip(n);
            this.pos += l;
            return l;
        }

        public long getPos() {
            return this.pos;
        }

        public void mark() {
            int n = 0x100000;
            LOG.fine("Marking with " + n + " at " + this.pos);
            this.inputStream.mark(n);
            this.markPos = this.pos;
        }

        public void reset() throws IOException {
            long l = this.pos - this.markPos;
            LOG.fine("Resetting to " + this.markPos + " (pos is " + this.pos + ") which makes the buffersize " + l);
            this.inputStream.reset();
            this.pos = this.markPos;
        }
    }

    public static class SliceHeader {
        public int first_mb_in_slice;
        public SliceType slice_type;
        public int pic_parameter_set_id;
        public int colour_plane_id;
        public int frame_num;
        public boolean field_pic_flag = false;
        public boolean bottom_field_flag = false;
        public int idr_pic_id;
        public int pic_order_cnt_lsb;
        public int delta_pic_order_cnt_bottom;

        public SliceHeader(InputStream inputStream, SeqParameterSet seqParameterSet, PictureParameterSet pictureParameterSet, boolean bl) throws IOException {
            inputStream.read();
            CAVLCReader cAVLCReader = new CAVLCReader(inputStream);
            this.first_mb_in_slice = cAVLCReader.readUE("SliceHeader: first_mb_in_slice");
            switch (cAVLCReader.readUE("SliceHeader: slice_type")) {
                case 0: 
                case 5: {
                    this.slice_type = SliceType.P;
                    break;
                }
                case 1: 
                case 6: {
                    this.slice_type = SliceType.B;
                    break;
                }
                case 2: 
                case 7: {
                    this.slice_type = SliceType.I;
                    break;
                }
                case 3: 
                case 8: {
                    this.slice_type = SliceType.SP;
                    break;
                }
                case 4: 
                case 9: {
                    this.slice_type = SliceType.SI;
                }
            }
            this.pic_parameter_set_id = cAVLCReader.readUE("SliceHeader: pic_parameter_set_id");
            if (seqParameterSet.residual_color_transform_flag) {
                this.colour_plane_id = cAVLCReader.readU(2, "SliceHeader: colour_plane_id");
            }
            this.frame_num = cAVLCReader.readU(seqParameterSet.log2_max_frame_num_minus4 + 4, "SliceHeader: frame_num");
            if (!seqParameterSet.frame_mbs_only_flag) {
                this.field_pic_flag = cAVLCReader.readBool("SliceHeader: field_pic_flag");
                if (this.field_pic_flag) {
                    this.bottom_field_flag = cAVLCReader.readBool("SliceHeader: bottom_field_flag");
                }
            }
            if (bl) {
                this.idr_pic_id = cAVLCReader.readUE("SliceHeader: idr_pic_id");
                if (seqParameterSet.pic_order_cnt_type == 0) {
                    this.pic_order_cnt_lsb = cAVLCReader.readU(seqParameterSet.log2_max_pic_order_cnt_lsb_minus4 + 4, "SliceHeader: pic_order_cnt_lsb");
                    if (pictureParameterSet.pic_order_present_flag && !this.field_pic_flag) {
                        this.delta_pic_order_cnt_bottom = cAVLCReader.readSE("SliceHeader: delta_pic_order_cnt_bottom");
                    }
                }
            }
        }

        public String toString() {
            return "SliceHeader{first_mb_in_slice=" + this.first_mb_in_slice + ", slice_type=" + (Object)((Object)this.slice_type) + ", pic_parameter_set_id=" + this.pic_parameter_set_id + ", colour_plane_id=" + this.colour_plane_id + ", frame_num=" + this.frame_num + ", field_pic_flag=" + this.field_pic_flag + ", bottom_field_flag=" + this.bottom_field_flag + ", idr_pic_id=" + this.idr_pic_id + ", pic_order_cnt_lsb=" + this.pic_order_cnt_lsb + ", delta_pic_order_cnt_bottom=" + this.delta_pic_order_cnt_bottom + '}';
        }

        public static enum SliceType {
            P,
            B,
            I,
            SP,
            SI;

        }
    }

    private static enum NALActions {
        IGNORE,
        BUFFER,
        STORE,
        END;

    }
}

