/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.EC3SpecificBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class EC3TrackImpl
extends AbstractTrack {
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox sampleDescriptionBox;
    int samplerate;
    int bitrate;
    int frameSize;
    List<BitStreamInfo> entries = new LinkedList<BitStreamInfo>();
    private BufferedInputStream inputStream;
    private List<ByteBuffer> samples;
    List<TimeToSampleBox.Entry> stts = new LinkedList<TimeToSampleBox.Entry>();
    private String lang = "und";

    public EC3TrackImpl(InputStream inputStream, String string) throws IOException {
        this.lang = string;
        this.parse(inputStream);
    }

    public EC3TrackImpl(InputStream inputStream) throws IOException {
        this.parse(inputStream);
    }

    private void parse(InputStream inputStream) throws IOException {
        Object object2;
        this.inputStream = new BufferedInputStream(inputStream);
        boolean bl = false;
        this.inputStream.mark(10000);
        while (!bl) {
            object2 = this.readVariables();
            if (object2 == null) {
                throw new IOException();
            }
            for (BitStreamInfo object3 : this.entries) {
                if (((BitStreamInfo)object2).strmtyp == 1 || object3.substreamid != ((BitStreamInfo)object2).substreamid) continue;
                bl = true;
            }
            if (bl) continue;
            this.entries.add((BitStreamInfo)object2);
            long l = this.inputStream.skip(((BitStreamInfo)object2).frameSize);
            assert (l == (long)((BitStreamInfo)object2).frameSize);
        }
        this.inputStream.reset();
        if (this.entries.size() == 0) {
            throw new IOException();
        }
        this.samplerate = this.entries.get((int)0).samplerate;
        this.sampleDescriptionBox = new SampleDescriptionBox();
        object2 = new AudioSampleEntry("ec-3");
        ((AudioSampleEntry)object2).setChannelCount(2);
        ((AudioSampleEntry)object2).setSampleRate(this.samplerate);
        ((SampleEntry)object2).setDataReferenceIndex(1);
        ((AudioSampleEntry)object2).setSampleSize(16);
        EC3SpecificBox eC3SpecificBox = new EC3SpecificBox();
        int[] nArray = new int[this.entries.size()];
        int[] nArray2 = new int[this.entries.size()];
        for (BitStreamInfo bitStreamInfo : this.entries) {
            if (bitStreamInfo.strmtyp != 1) continue;
            int n = bitStreamInfo.substreamid;
            nArray[n] = nArray[n] + 1;
            nArray2[bitStreamInfo.substreamid] = bitStreamInfo.chanmap >> 6 & 0x100 | bitStreamInfo.chanmap >> 5 & 0xFF;
        }
        for (BitStreamInfo bitStreamInfo : this.entries) {
            if (bitStreamInfo.strmtyp != 1) {
                EC3SpecificBox.Entry entry = new EC3SpecificBox.Entry();
                entry.fscod = bitStreamInfo.fscod;
                entry.bsid = bitStreamInfo.bsid;
                entry.bsmod = bitStreamInfo.bsmod;
                entry.acmod = bitStreamInfo.acmod;
                entry.lfeon = bitStreamInfo.lfeon;
                entry.reserved = 0;
                entry.num_dep_sub = nArray[bitStreamInfo.substreamid];
                entry.chan_loc = nArray2[bitStreamInfo.substreamid];
                entry.reserved2 = 0;
                eC3SpecificBox.addEntry(entry);
            }
            this.bitrate += bitStreamInfo.bitrate;
            this.frameSize += bitStreamInfo.frameSize;
        }
        eC3SpecificBox.setDataRate(this.bitrate / 1000);
        ((SampleEntry)object2).addBox(eC3SpecificBox);
        this.sampleDescriptionBox.addBox((Box)object2);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(this.lang);
        this.trackMetaData.setTimescale(this.samplerate);
        this.samples = new LinkedList<ByteBuffer>();
        if (!this.readSamples()) {
            throw new IOException();
        }
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.stts;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return new SoundMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    private BitStreamInfo readVariables() throws IOException {
        int n;
        byte[] byArray = new byte[200];
        this.inputStream.mark(200);
        if (200 != this.inputStream.read(byArray, 0, 200)) {
            return null;
        }
        this.inputStream.reset();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        BitReaderBuffer bitReaderBuffer = new BitReaderBuffer(byteBuffer);
        int n2 = bitReaderBuffer.readBits(16);
        if (n2 != 2935) {
            return null;
        }
        BitStreamInfo bitStreamInfo = new BitStreamInfo();
        bitStreamInfo.strmtyp = bitReaderBuffer.readBits(2);
        bitStreamInfo.substreamid = bitReaderBuffer.readBits(3);
        int n3 = bitReaderBuffer.readBits(11);
        bitStreamInfo.frameSize = 2 * (n3 + 1);
        bitStreamInfo.fscod = bitReaderBuffer.readBits(2);
        int n4 = -1;
        if (bitStreamInfo.fscod == 3) {
            n4 = bitReaderBuffer.readBits(2);
            n = 3;
        } else {
            n = bitReaderBuffer.readBits(2);
        }
        int n5 = 0;
        switch (n) {
            case 0: {
                n5 = 1;
                break;
            }
            case 1: {
                n5 = 2;
                break;
            }
            case 2: {
                n5 = 3;
                break;
            }
            case 3: {
                n5 = 6;
            }
        }
        bitStreamInfo.frameSize *= 6 / n5;
        bitStreamInfo.acmod = bitReaderBuffer.readBits(3);
        bitStreamInfo.lfeon = bitReaderBuffer.readBits(1);
        bitStreamInfo.bsid = bitReaderBuffer.readBits(5);
        bitReaderBuffer.readBits(5);
        if (1 == bitReaderBuffer.readBits(1)) {
            bitReaderBuffer.readBits(8);
        }
        if (0 == bitStreamInfo.acmod) {
            bitReaderBuffer.readBits(5);
            if (1 == bitReaderBuffer.readBits(1)) {
                bitReaderBuffer.readBits(8);
            }
        }
        if (1 == bitStreamInfo.strmtyp && 1 == bitReaderBuffer.readBits(1)) {
            bitStreamInfo.chanmap = bitReaderBuffer.readBits(16);
        }
        if (1 == bitReaderBuffer.readBits(1)) {
            if (bitStreamInfo.acmod > 2) {
                bitReaderBuffer.readBits(2);
            }
            if (1 == (bitStreamInfo.acmod & 1) && bitStreamInfo.acmod > 2) {
                bitReaderBuffer.readBits(3);
                bitReaderBuffer.readBits(3);
            }
            if (0 < (bitStreamInfo.acmod & 4)) {
                bitReaderBuffer.readBits(3);
                bitReaderBuffer.readBits(3);
            }
            if (1 == bitStreamInfo.lfeon && 1 == bitReaderBuffer.readBits(1)) {
                bitReaderBuffer.readBits(5);
            }
            if (0 == bitStreamInfo.strmtyp) {
                int n6;
                int n7;
                if (1 == bitReaderBuffer.readBits(1)) {
                    bitReaderBuffer.readBits(6);
                }
                if (0 == bitStreamInfo.acmod && 1 == bitReaderBuffer.readBits(1)) {
                    bitReaderBuffer.readBits(6);
                }
                if (1 == bitReaderBuffer.readBits(1)) {
                    bitReaderBuffer.readBits(6);
                }
                if (1 == (n7 = bitReaderBuffer.readBits(2))) {
                    bitReaderBuffer.readBits(5);
                } else if (2 == n7) {
                    bitReaderBuffer.readBits(12);
                } else if (3 == n7) {
                    n6 = bitReaderBuffer.readBits(5);
                    if (1 == bitReaderBuffer.readBits(1)) {
                        bitReaderBuffer.readBits(5);
                        if (1 == bitReaderBuffer.readBits(1)) {
                            bitReaderBuffer.readBits(4);
                        }
                        if (1 == bitReaderBuffer.readBits(1)) {
                            bitReaderBuffer.readBits(4);
                        }
                        if (1 == bitReaderBuffer.readBits(1)) {
                            bitReaderBuffer.readBits(4);
                        }
                        if (1 == bitReaderBuffer.readBits(1)) {
                            bitReaderBuffer.readBits(4);
                        }
                        if (1 == bitReaderBuffer.readBits(1)) {
                            bitReaderBuffer.readBits(4);
                        }
                        if (1 == bitReaderBuffer.readBits(1)) {
                            bitReaderBuffer.readBits(4);
                        }
                        if (1 == bitReaderBuffer.readBits(1)) {
                            bitReaderBuffer.readBits(4);
                        }
                        if (1 == bitReaderBuffer.readBits(1)) {
                            if (1 == bitReaderBuffer.readBits(1)) {
                                bitReaderBuffer.readBits(4);
                            }
                            if (1 == bitReaderBuffer.readBits(1)) {
                                bitReaderBuffer.readBits(4);
                            }
                        }
                    }
                    if (1 == bitReaderBuffer.readBits(1)) {
                        bitReaderBuffer.readBits(5);
                        if (1 == bitReaderBuffer.readBits(1)) {
                            bitReaderBuffer.readBits(7);
                            if (1 == bitReaderBuffer.readBits(1)) {
                                bitReaderBuffer.readBits(8);
                            }
                        }
                    }
                    for (int i = 0; i < n6 + 2; ++i) {
                        bitReaderBuffer.readBits(8);
                    }
                    bitReaderBuffer.byteSync();
                }
                if (bitStreamInfo.acmod < 2) {
                    if (1 == bitReaderBuffer.readBits(1)) {
                        bitReaderBuffer.readBits(14);
                    }
                    if (0 == bitStreamInfo.acmod && 1 == bitReaderBuffer.readBits(1)) {
                        bitReaderBuffer.readBits(14);
                    }
                    if (1 == bitReaderBuffer.readBits(1)) {
                        if (n == 0) {
                            bitReaderBuffer.readBits(5);
                        } else {
                            for (n6 = 0; n6 < n5; ++n6) {
                                if (1 != bitReaderBuffer.readBits(1)) continue;
                                bitReaderBuffer.readBits(5);
                            }
                        }
                    }
                }
            }
        }
        if (1 == bitReaderBuffer.readBits(1)) {
            bitStreamInfo.bsmod = bitReaderBuffer.readBits(3);
        }
        block6 : switch (bitStreamInfo.fscod) {
            case 0: {
                bitStreamInfo.samplerate = 48000;
                break;
            }
            case 1: {
                bitStreamInfo.samplerate = 44100;
                break;
            }
            case 2: {
                bitStreamInfo.samplerate = 32000;
                break;
            }
            case 3: {
                switch (n4) {
                    case 0: {
                        bitStreamInfo.samplerate = 24000;
                        break block6;
                    }
                    case 1: {
                        bitStreamInfo.samplerate = 22050;
                        break block6;
                    }
                    case 2: {
                        bitStreamInfo.samplerate = 16000;
                        break block6;
                    }
                    case 3: {
                        bitStreamInfo.samplerate = 0;
                    }
                }
            }
        }
        if (bitStreamInfo.samplerate == 0) {
            return null;
        }
        bitStreamInfo.bitrate = (int)((double)bitStreamInfo.samplerate / 1536.0 * (double)bitStreamInfo.frameSize * 8.0);
        return bitStreamInfo;
    }

    private boolean readSamples() throws IOException {
        int n = this.frameSize;
        boolean bl = false;
        while (this.frameSize == n) {
            bl = true;
            byte[] byArray = new byte[this.frameSize];
            n = this.inputStream.read(byArray);
            if (n != this.frameSize) continue;
            this.samples.add(ByteBuffer.wrap(byArray));
            this.stts.add(new TimeToSampleBox.Entry(1L, 1536L));
        }
        return bl;
    }

    public String toString() {
        return "EC3TrackImpl{bitrate=" + this.bitrate + ", samplerate=" + this.samplerate + ", entries=" + this.entries + '}';
    }

    public static class BitStreamInfo
    extends EC3SpecificBox.Entry {
        public int frameSize;
        public int substreamid;
        public int bitrate;
        public int samplerate;
        public int strmtyp;
        public int chanmap;

        @Override
        public String toString() {
            return "BitStreamInfo{frameSize=" + this.frameSize + ", substreamid=" + this.substreamid + ", bitrate=" + this.bitrate + ", samplerate=" + this.samplerate + ", strmtyp=" + this.strmtyp + ", chanmap=" + this.chanmap + '}';
        }
    }
}

