/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.adaptivestreaming;

import com.coremedia.iso.boxes.OriginalFormatBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.adaptivestreaming.ManifestWriter;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class AbstractManifestWriter
implements ManifestWriter {
    private static final Logger LOG = Logger.getLogger(AbstractManifestWriter.class.getName());
    private FragmentIntersectionFinder intersectionFinder;
    protected long[] audioFragmentsDurations;
    protected long[] videoFragmentsDurations;

    protected AbstractManifestWriter(FragmentIntersectionFinder fragmentIntersectionFinder) {
        this.intersectionFinder = fragmentIntersectionFinder;
    }

    @Override
    public long[] calculateFragmentDurations(Track track, Movie movie) {
        long[] lArray = this.intersectionFinder.sampleNumbers(track, movie);
        long[] lArray2 = new long[lArray.length];
        int n = 0;
        int n2 = 1;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            int n3 = n2 + CastUtils.l2i(entry.getCount());
            while (n2 < n3) {
                if (n == lArray.length - 1 || (long)n2 == lArray[n + 1]) {
                    // empty if block
                }
                int n4 = ++n;
                lArray2[n4] = lArray2[n4] + entry.getDelta();
                ++n2;
            }
        }
        return lArray2;
    }

    @Override
    public long getBitrate(Track track) {
        long l = 0L;
        for (ByteBuffer byteBuffer : track.getSamples()) {
            l += (long)byteBuffer.limit();
        }
        l *= 8L;
        l = (long)((double)l / ((double)AbstractManifestWriter.getDuration(track) / (double)track.getTrackMetaData().getTimescale()));
        return l;
    }

    protected static long getDuration(Track track) {
        long l = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            l += entry.getCount() * entry.getDelta();
        }
        return l;
    }

    protected long[] checkFragmentsAlign(long[] lArray, long[] lArray2) throws IOException {
        if (lArray == null || lArray.length == 0) {
            return lArray2;
        }
        long[] lArray3 = new long[lArray.length - 1];
        System.arraycopy(lArray, 0, lArray3, 0, lArray.length - 1);
        long[] lArray4 = new long[lArray2.length - 1];
        System.arraycopy(lArray2, 0, lArray4, 0, lArray2.length - 1);
        if (!Arrays.equals(lArray4, lArray3)) {
            String string = "";
            string = string + lArray.length;
            string = string + "Reference     :  [";
            for (long l : lArray) {
                string = string + String.format("%10d,", l);
            }
            string = string + "]";
            LOG.warning(string);
            string = "";
            string = string + lArray2.length;
            string = string + "Current       :  [";
            for (long l : lArray2) {
                string = string + String.format("%10d,", l);
            }
            string = string + "]";
            LOG.warning(string);
            throw new IOException("Track does not have the same fragment borders as its predecessor.");
        }
        return lArray2;
    }

    protected String getFormat(SampleEntry sampleEntry) {
        String string = sampleEntry.getType();
        if (string.equals("encv") || string.equals("enca") || string.equals("encv")) {
            OriginalFormatBox originalFormatBox = sampleEntry.getBoxes(OriginalFormatBox.class, true).get(0);
            string = originalFormatBox.getDataFormat();
        }
        return string;
    }
}

