/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.nio.ByteBuffer;

public class SubtitleSampleEntry
extends SampleEntry {
    public static final String TYPE1 = "stpp";
    public static final String TYPE_ENCRYPTED = "";
    private String namespace;
    private String schemaLocation;
    private String imageMimeType;

    public SubtitleSampleEntry(String string) {
        super(string);
    }

    @Override
    protected long getContentSize() {
        long l = 8 + this.namespace.length() + this.schemaLocation.length() + this.imageMimeType.length() + 3;
        return l;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this._parseReservedAndDataReferenceIndex(byteBuffer);
        this.namespace = IsoTypeReader.readString(byteBuffer);
        this.schemaLocation = IsoTypeReader.readString(byteBuffer);
        this.imageMimeType = IsoTypeReader.readString(byteBuffer);
        this._parseChildBoxes(byteBuffer);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this._writeReservedAndDataReferenceIndex(byteBuffer);
        IsoTypeWriter.writeUtf8String(byteBuffer, this.namespace);
        IsoTypeWriter.writeUtf8String(byteBuffer, this.schemaLocation);
        IsoTypeWriter.writeUtf8String(byteBuffer, this.imageMimeType);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    public String getImageMimeType() {
        return this.imageMimeType;
    }

    public void setImageMimeType(String string) {
        this.imageMimeType = string;
    }
}

