/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.nio.ByteBuffer;

public class AudioSampleEntry
extends SampleEntry
implements ContainerBox {
    public static final String TYPE1 = "samr";
    public static final String TYPE2 = "sawb";
    public static final String TYPE3 = "mp4a";
    public static final String TYPE4 = "drms";
    public static final String TYPE5 = "alac";
    public static final String TYPE7 = "owma";
    public static final String TYPE8 = "ac-3";
    public static final String TYPE9 = "ec-3";
    public static final String TYPE10 = "mlpa";
    public static final String TYPE11 = "dtsl";
    public static final String TYPE12 = "dtsh";
    public static final String TYPE13 = "dtse";
    public static final String TYPE_ENCRYPTED = "enca";
    private int channelCount;
    private int sampleSize;
    private long sampleRate;
    private int soundVersion;
    private int compressionId;
    private int packetSize;
    private long samplesPerPacket;
    private long bytesPerPacket;
    private long bytesPerFrame;
    private long bytesPerSample;
    private int reserved1;
    private long reserved2;
    private byte[] soundVersion2Data;
    private BoxParser boxParser;

    public AudioSampleEntry(String string) {
        super(string);
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public long getSampleRate() {
        return this.sampleRate;
    }

    public int getSoundVersion() {
        return this.soundVersion;
    }

    public int getCompressionId() {
        return this.compressionId;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public long getSamplesPerPacket() {
        return this.samplesPerPacket;
    }

    public long getBytesPerPacket() {
        return this.bytesPerPacket;
    }

    public long getBytesPerFrame() {
        return this.bytesPerFrame;
    }

    public long getBytesPerSample() {
        return this.bytesPerSample;
    }

    public byte[] getSoundVersion2Data() {
        return this.soundVersion2Data;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public long getReserved2() {
        return this.reserved2;
    }

    public void setChannelCount(int n) {
        this.channelCount = n;
    }

    public void setSampleSize(int n) {
        this.sampleSize = n;
    }

    public void setSampleRate(long l) {
        this.sampleRate = l;
    }

    public void setSoundVersion(int n) {
        this.soundVersion = n;
    }

    public void setCompressionId(int n) {
        this.compressionId = n;
    }

    public void setPacketSize(int n) {
        this.packetSize = n;
    }

    public void setSamplesPerPacket(long l) {
        this.samplesPerPacket = l;
    }

    public void setBytesPerPacket(long l) {
        this.bytesPerPacket = l;
    }

    public void setBytesPerFrame(long l) {
        this.bytesPerFrame = l;
    }

    public void setBytesPerSample(long l) {
        this.bytesPerSample = l;
    }

    public void setReserved1(int n) {
        this.reserved1 = n;
    }

    public void setReserved2(long l) {
        this.reserved2 = l;
    }

    public void setSoundVersion2Data(byte[] byArray) {
        this.soundVersion2Data = byArray;
    }

    public void setBoxParser(BoxParser boxParser) {
        this.boxParser = boxParser;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this._parseReservedAndDataReferenceIndex(byteBuffer);
        this.soundVersion = IsoTypeReader.readUInt16(byteBuffer);
        this.reserved1 = IsoTypeReader.readUInt16(byteBuffer);
        this.reserved2 = IsoTypeReader.readUInt32(byteBuffer);
        this.channelCount = IsoTypeReader.readUInt16(byteBuffer);
        this.sampleSize = IsoTypeReader.readUInt16(byteBuffer);
        this.compressionId = IsoTypeReader.readUInt16(byteBuffer);
        this.packetSize = IsoTypeReader.readUInt16(byteBuffer);
        this.sampleRate = IsoTypeReader.readUInt32(byteBuffer);
        if (!this.type.equals(TYPE10)) {
            this.sampleRate >>>= 16;
        }
        if (this.soundVersion > 0) {
            this.samplesPerPacket = IsoTypeReader.readUInt32(byteBuffer);
            this.bytesPerPacket = IsoTypeReader.readUInt32(byteBuffer);
            this.bytesPerFrame = IsoTypeReader.readUInt32(byteBuffer);
            this.bytesPerSample = IsoTypeReader.readUInt32(byteBuffer);
        }
        if (this.soundVersion == 2) {
            this.soundVersion2Data = new byte[20];
            byteBuffer.get(20);
        }
        this._parseChildBoxes(byteBuffer);
    }

    @Override
    protected long getContentSize() {
        long l = 28L;
        l += this.soundVersion > 0 ? 16L : 0L;
        l += this.soundVersion == 2 ? 20L : 0L;
        for (Box box : this.boxes) {
            l += box.getSize();
        }
        return l;
    }

    public String toString() {
        return "AudioSampleEntry{bytesPerSample=" + this.bytesPerSample + ", bytesPerFrame=" + this.bytesPerFrame + ", bytesPerPacket=" + this.bytesPerPacket + ", samplesPerPacket=" + this.samplesPerPacket + ", packetSize=" + this.packetSize + ", compressionId=" + this.compressionId + ", soundVersion=" + this.soundVersion + ", sampleRate=" + this.sampleRate + ", sampleSize=" + this.sampleSize + ", channelCount=" + this.channelCount + ", boxes=" + this.getBoxes() + '}';
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this._writeReservedAndDataReferenceIndex(byteBuffer);
        IsoTypeWriter.writeUInt16(byteBuffer, this.soundVersion);
        IsoTypeWriter.writeUInt16(byteBuffer, this.reserved1);
        IsoTypeWriter.writeUInt32(byteBuffer, this.reserved2);
        IsoTypeWriter.writeUInt16(byteBuffer, this.channelCount);
        IsoTypeWriter.writeUInt16(byteBuffer, this.sampleSize);
        IsoTypeWriter.writeUInt16(byteBuffer, this.compressionId);
        IsoTypeWriter.writeUInt16(byteBuffer, this.packetSize);
        if (this.type.equals(TYPE10)) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSampleRate());
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSampleRate() << 16);
        }
        if (this.soundVersion > 0) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.samplesPerPacket);
            IsoTypeWriter.writeUInt32(byteBuffer, this.bytesPerPacket);
            IsoTypeWriter.writeUInt32(byteBuffer, this.bytesPerFrame);
            IsoTypeWriter.writeUInt32(byteBuffer, this.bytesPerSample);
        }
        if (this.soundVersion == 2) {
            byteBuffer.put(this.soundVersion2Data);
        }
        this._writeChildBoxes(byteBuffer);
    }
}

