/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.ChannelHelper;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.LazyList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Logger;

public final class MediaDataBox
implements Box {
    private static Logger LOG = Logger.getLogger(MediaDataBox.class.getName());
    public static final String TYPE = "mdat";
    public static final int BUFFER_SIZE = 0xA00000;
    ContainerBox parent;
    ByteBuffer header;
    private FileChannel fileChannel;
    private long startPosition;
    private long contentSize;
    private ByteBuffer content;
    ByteBuffer cacheSliceCurrentlyInUse = null;
    long cacheSliceCurrentlyInUseStart = Long.MAX_VALUE;

    @Override
    public ContainerBox getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ContainerBox containerBox) {
        this.parent = containerBox;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private static void transfer(FileChannel fileChannel, long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        long l3 = 67076096L;
        for (long i = 0L; i < l2; i += fileChannel.transferTo(l + i, Math.min(l3, l2 - i), writableByteChannel)) {
        }
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        if (this.fileChannel != null) {
            assert (this.checkStillOk());
            MediaDataBox.transfer(this.fileChannel, this.startPosition - (long)this.header.limit(), this.contentSize + (long)this.header.limit(), writableByteChannel);
        } else {
            this.header.rewind();
            writableByteChannel.write(this.header);
            writableByteChannel.write(this.content);
        }
    }

    private boolean checkStillOk() {
        try {
            this.fileChannel.position(this.startPosition - (long)this.header.limit());
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.header.limit());
            this.fileChannel.read(byteBuffer);
            this.header.rewind();
            byteBuffer.rewind();
            assert (byteBuffer.equals(this.header)) : "It seems that the content I want to read has already been overwritten.";
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    @Override
    public long getSize() {
        long l = this.header.limit();
        return l += this.contentSize;
    }

    public long getDataStartPosition() {
        return this.startPosition;
    }

    public long getDataEndPosition() {
        return this.startPosition + this.contentSize;
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, BoxParser boxParser) throws IOException {
        this.header = byteBuffer;
        this.contentSize = l;
        if (readableByteChannel instanceof FileChannel) {
            this.fileChannel = (FileChannel)readableByteChannel;
            this.startPosition = ((FileChannel)readableByteChannel).position();
            ((FileChannel)readableByteChannel).position(((FileChannel)readableByteChannel).position() + l);
        } else {
            this.content = ChannelHelper.readFully(readableByteChannel, CastUtils.l2i(l));
            this.startPosition = 0L;
            for (Box box : ((LazyList)this.getParent().getBoxes()).getUnderlying()) {
                this.startPosition += box.getSize();
            }
            this.startPosition += (long)byteBuffer.limit();
            this.cacheSliceCurrentlyInUse = this.content;
            this.cacheSliceCurrentlyInUseStart = 0L;
        }
    }

    public synchronized ByteBuffer getContent(long l, int n) {
        MappedByteBuffer mappedByteBuffer;
        if (this.cacheSliceCurrentlyInUseStart <= l && this.cacheSliceCurrentlyInUse != null && l + (long)n <= this.cacheSliceCurrentlyInUseStart + (long)this.cacheSliceCurrentlyInUse.limit()) {
            ByteBuffer byteBuffer = this.cacheSliceCurrentlyInUse.asReadOnlyBuffer();
            byteBuffer.position((int)(l - this.cacheSliceCurrentlyInUseStart));
            byteBuffer.mark();
            byteBuffer.limit((int)(l - this.cacheSliceCurrentlyInUseStart) + n);
            return byteBuffer;
        }
        try {
            mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.startPosition + l, Math.min(0xA00000L, this.contentSize - l));
        }
        catch (IOException iOException) {
            LOG.fine("Even mapping just 10MB of the source file into the memory failed. " + iOException);
            throw new RuntimeException("Delayed reading of mdat content failed. Make sure not to close the FileChannel that has been used to create the IsoFile!", iOException);
        }
        this.cacheSliceCurrentlyInUse = mappedByteBuffer;
        this.cacheSliceCurrentlyInUseStart = l;
        ByteBuffer byteBuffer = this.cacheSliceCurrentlyInUse.asReadOnlyBuffer();
        byteBuffer.position(0);
        byteBuffer.mark();
        byteBuffer.limit(n);
        return byteBuffer;
    }
}

