/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.h264;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitWriterBuffer;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AvcConfigurationBox
extends AbstractBox {
    public static final String TYPE = "avcC";
    public AVCDecoderConfigurationRecord avcDecoderConfigurationRecord = new AVCDecoderConfigurationRecord();

    public AvcConfigurationBox() {
        super(TYPE);
    }

    public int getConfigurationVersion() {
        return this.avcDecoderConfigurationRecord.configurationVersion;
    }

    public int getAvcProfileIndication() {
        return this.avcDecoderConfigurationRecord.avcProfileIndication;
    }

    public int getProfileCompatibility() {
        return this.avcDecoderConfigurationRecord.profileCompatibility;
    }

    public int getAvcLevelIndication() {
        return this.avcDecoderConfigurationRecord.avcLevelIndication;
    }

    public int getLengthSizeMinusOne() {
        return this.avcDecoderConfigurationRecord.lengthSizeMinusOne;
    }

    public List<byte[]> getSequenceParameterSets() {
        return Collections.unmodifiableList(this.avcDecoderConfigurationRecord.sequenceParameterSets);
    }

    public List<byte[]> getPictureParameterSets() {
        return Collections.unmodifiableList(this.avcDecoderConfigurationRecord.pictureParameterSets);
    }

    public void setConfigurationVersion(int n) {
        this.avcDecoderConfigurationRecord.configurationVersion = n;
    }

    public void setAvcProfileIndication(int n) {
        this.avcDecoderConfigurationRecord.avcProfileIndication = n;
    }

    public void setProfileCompatibility(int n) {
        this.avcDecoderConfigurationRecord.profileCompatibility = n;
    }

    public void setAvcLevelIndication(int n) {
        this.avcDecoderConfigurationRecord.avcLevelIndication = n;
    }

    public void setLengthSizeMinusOne(int n) {
        this.avcDecoderConfigurationRecord.lengthSizeMinusOne = n;
    }

    public void setSequenceParameterSets(List<byte[]> list) {
        this.avcDecoderConfigurationRecord.sequenceParameterSets = list;
    }

    public void setPictureParameterSets(List<byte[]> list) {
        this.avcDecoderConfigurationRecord.pictureParameterSets = list;
    }

    public int getChromaFormat() {
        return this.avcDecoderConfigurationRecord.chromaFormat;
    }

    public void setChromaFormat(int n) {
        this.avcDecoderConfigurationRecord.chromaFormat = n;
    }

    public int getBitDepthLumaMinus8() {
        return this.avcDecoderConfigurationRecord.bitDepthLumaMinus8;
    }

    public void setBitDepthLumaMinus8(int n) {
        this.avcDecoderConfigurationRecord.bitDepthLumaMinus8 = n;
    }

    public int getBitDepthChromaMinus8() {
        return this.avcDecoderConfigurationRecord.bitDepthChromaMinus8;
    }

    public void setBitDepthChromaMinus8(int n) {
        this.avcDecoderConfigurationRecord.bitDepthChromaMinus8 = n;
    }

    public List<byte[]> getSequenceParameterSetExts() {
        return this.avcDecoderConfigurationRecord.sequenceParameterSetExts;
    }

    public void setSequenceParameterSetExts(List<byte[]> list) {
        this.avcDecoderConfigurationRecord.sequenceParameterSetExts = list;
    }

    public boolean hasExts() {
        return this.avcDecoderConfigurationRecord.hasExts;
    }

    public void setHasExts(boolean bl) {
        this.avcDecoderConfigurationRecord.hasExts = bl;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.avcDecoderConfigurationRecord = new AVCDecoderConfigurationRecord(byteBuffer);
    }

    @Override
    public long getContentSize() {
        return this.avcDecoderConfigurationRecord.getContentSize();
    }

    @Override
    public void getContent(ByteBuffer byteBuffer) {
        this.avcDecoderConfigurationRecord.getContent(byteBuffer);
    }

    public String[] getSPS() {
        return this.avcDecoderConfigurationRecord.getSPS();
    }

    public String[] getPPS() {
        return this.avcDecoderConfigurationRecord.getPPS();
    }

    public AVCDecoderConfigurationRecord getavcDecoderConfigurationRecord() {
        return this.avcDecoderConfigurationRecord;
    }

    public static class AVCDecoderConfigurationRecord {
        public int configurationVersion;
        public int avcProfileIndication;
        public int profileCompatibility;
        public int avcLevelIndication;
        public int lengthSizeMinusOne;
        public List<byte[]> sequenceParameterSets = new ArrayList<byte[]>();
        public List<byte[]> pictureParameterSets = new ArrayList<byte[]>();
        public boolean hasExts = true;
        public int chromaFormat = 1;
        public int bitDepthLumaMinus8 = 0;
        public int bitDepthChromaMinus8 = 0;
        public List<byte[]> sequenceParameterSetExts = new ArrayList<byte[]>();
        public int lengthSizeMinusOnePaddingBits = 63;
        public int numberOfSequenceParameterSetsPaddingBits = 7;
        public int chromaFormatPaddingBits = 31;
        public int bitDepthLumaMinus8PaddingBits = 31;
        public int bitDepthChromaMinus8PaddingBits = 31;

        public AVCDecoderConfigurationRecord() {
        }

        public AVCDecoderConfigurationRecord(ByteBuffer byteBuffer) {
            this.configurationVersion = IsoTypeReader.readUInt8(byteBuffer);
            this.avcProfileIndication = IsoTypeReader.readUInt8(byteBuffer);
            this.profileCompatibility = IsoTypeReader.readUInt8(byteBuffer);
            this.avcLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            BitReaderBuffer bitReaderBuffer = new BitReaderBuffer(byteBuffer);
            this.lengthSizeMinusOnePaddingBits = bitReaderBuffer.readBits(6);
            this.lengthSizeMinusOne = bitReaderBuffer.readBits(2);
            this.numberOfSequenceParameterSetsPaddingBits = bitReaderBuffer.readBits(3);
            int n = bitReaderBuffer.readBits(5);
            for (int i = 0; i < n; ++i) {
                int n2 = IsoTypeReader.readUInt16(byteBuffer);
                byte[] byArray = new byte[n2];
                byteBuffer.get(byArray);
                this.sequenceParameterSets.add(byArray);
            }
            long l = IsoTypeReader.readUInt8(byteBuffer);
            int n3 = 0;
            while ((long)n3 < l) {
                int n4 = IsoTypeReader.readUInt16(byteBuffer);
                byte[] byArray = new byte[n4];
                byteBuffer.get(byArray);
                this.pictureParameterSets.add(byArray);
                ++n3;
            }
            if (byteBuffer.remaining() < 4) {
                this.hasExts = false;
            }
            if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
                bitReaderBuffer = new BitReaderBuffer(byteBuffer);
                this.chromaFormatPaddingBits = bitReaderBuffer.readBits(6);
                this.chromaFormat = bitReaderBuffer.readBits(2);
                this.bitDepthLumaMinus8PaddingBits = bitReaderBuffer.readBits(5);
                this.bitDepthLumaMinus8 = bitReaderBuffer.readBits(3);
                this.bitDepthChromaMinus8PaddingBits = bitReaderBuffer.readBits(5);
                this.bitDepthChromaMinus8 = bitReaderBuffer.readBits(3);
                long l2 = IsoTypeReader.readUInt8(byteBuffer);
                int n5 = 0;
                while ((long)n5 < l2) {
                    int n6 = IsoTypeReader.readUInt16(byteBuffer);
                    byte[] byArray = new byte[n6];
                    byteBuffer.get(byArray);
                    this.sequenceParameterSetExts.add(byArray);
                    ++n5;
                }
            } else {
                this.chromaFormat = -1;
                this.bitDepthLumaMinus8 = -1;
                this.bitDepthChromaMinus8 = -1;
            }
        }

        public void getContent(ByteBuffer byteBuffer) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.configurationVersion);
            IsoTypeWriter.writeUInt8(byteBuffer, this.avcProfileIndication);
            IsoTypeWriter.writeUInt8(byteBuffer, this.profileCompatibility);
            IsoTypeWriter.writeUInt8(byteBuffer, this.avcLevelIndication);
            BitWriterBuffer bitWriterBuffer = new BitWriterBuffer(byteBuffer);
            bitWriterBuffer.writeBits(this.lengthSizeMinusOnePaddingBits, 6);
            bitWriterBuffer.writeBits(this.lengthSizeMinusOne, 2);
            bitWriterBuffer.writeBits(this.numberOfSequenceParameterSetsPaddingBits, 3);
            bitWriterBuffer.writeBits(this.pictureParameterSets.size(), 5);
            for (byte[] byArray : this.sequenceParameterSets) {
                IsoTypeWriter.writeUInt16(byteBuffer, byArray.length);
                byteBuffer.put(byArray);
            }
            IsoTypeWriter.writeUInt8(byteBuffer, this.pictureParameterSets.size());
            for (byte[] byArray : this.pictureParameterSets) {
                IsoTypeWriter.writeUInt16(byteBuffer, byArray.length);
                byteBuffer.put(byArray);
            }
            if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
                bitWriterBuffer = new BitWriterBuffer(byteBuffer);
                bitWriterBuffer.writeBits(this.chromaFormatPaddingBits, 6);
                bitWriterBuffer.writeBits(this.chromaFormat, 2);
                bitWriterBuffer.writeBits(this.bitDepthLumaMinus8PaddingBits, 5);
                bitWriterBuffer.writeBits(this.bitDepthLumaMinus8, 3);
                bitWriterBuffer.writeBits(this.bitDepthChromaMinus8PaddingBits, 5);
                bitWriterBuffer.writeBits(this.bitDepthChromaMinus8, 3);
                for (byte[] byArray : this.sequenceParameterSetExts) {
                    IsoTypeWriter.writeUInt16(byteBuffer, byArray.length);
                    byteBuffer.put(byArray);
                }
            }
        }

        public long getContentSize() {
            long l = 5L;
            ++l;
            for (byte[] byArray : this.sequenceParameterSets) {
                l += 2L;
                l += (long)byArray.length;
            }
            ++l;
            for (byte[] byArray : this.pictureParameterSets) {
                l += 2L;
                l += (long)byArray.length;
            }
            if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
                l += 4L;
                for (byte[] byArray : this.sequenceParameterSetExts) {
                    l += 2L;
                    l += (long)byArray.length;
                }
            }
            return l;
        }

        public String[] getPPS() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (byte[] byArray : this.pictureParameterSets) {
                String string = "not parsable";
                try {
                    string = PictureParameterSet.read(new ByteArrayInputStream(byArray, 1, byArray.length - 1)).toString();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                arrayList.add(string);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public String[] getSPS() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (byte[] byArray : this.sequenceParameterSets) {
                String string = "not parsable";
                try {
                    string = SeqParameterSet.read(new ByteArrayInputStream(byArray, 1, byArray.length - 1)).toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                arrayList.add(string);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public List<String> getSequenceParameterSetsAsStrings() {
            ArrayList<String> arrayList = new ArrayList<String>(this.sequenceParameterSets.size());
            for (byte[] byArray : this.sequenceParameterSets) {
                arrayList.add(Hex.encodeHex(byArray));
            }
            return arrayList;
        }

        public List<String> getSequenceParameterSetExtsAsStrings() {
            ArrayList<String> arrayList = new ArrayList<String>(this.sequenceParameterSetExts.size());
            for (byte[] byArray : this.sequenceParameterSetExts) {
                arrayList.add(Hex.encodeHex(byArray));
            }
            return arrayList;
        }

        public List<String> getPictureParameterSetsAsStrings() {
            ArrayList<String> arrayList = new ArrayList<String>(this.pictureParameterSets.size());
            for (byte[] byArray : this.pictureParameterSets) {
                arrayList.add(Hex.encodeHex(byArray));
            }
            return arrayList;
        }
    }
}

