/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.annotations.DoNotParseDetail;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class FileTypeBox
extends AbstractBox {
    public static final String TYPE = "ftyp";
    private String majorBrand;
    private long minorVersion;
    private List<String> compatibleBrands = Collections.emptyList();

    public FileTypeBox() {
        super(TYPE);
    }

    public FileTypeBox(String string, long l, List<String> list) {
        super(TYPE);
        this.majorBrand = string;
        this.minorVersion = l;
        this.compatibleBrands = list;
    }

    @Override
    protected long getContentSize() {
        return 8 + this.compatibleBrands.size() * 4;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.majorBrand = IsoTypeReader.read4cc(byteBuffer);
        this.minorVersion = IsoTypeReader.readUInt32(byteBuffer);
        int n = byteBuffer.remaining() / 4;
        this.compatibleBrands = new LinkedList<String>();
        for (int i = 0; i < n; ++i) {
            this.compatibleBrands.add(IsoTypeReader.read4cc(byteBuffer));
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        byteBuffer.put(IsoFile.fourCCtoBytes(this.majorBrand));
        IsoTypeWriter.writeUInt32(byteBuffer, this.minorVersion);
        for (String string : this.compatibleBrands) {
            byteBuffer.put(IsoFile.fourCCtoBytes(string));
        }
    }

    public String getMajorBrand() {
        return this.majorBrand;
    }

    public void setMajorBrand(String string) {
        this.majorBrand = string;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public long getMinorVersion() {
        return this.minorVersion;
    }

    public List<String> getCompatibleBrands() {
        return this.compatibleBrands;
    }

    public void setCompatibleBrands(List<String> list) {
        this.compatibleBrands = list;
    }

    @DoNotParseDetail
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FileTypeBox[");
        stringBuilder.append("majorBrand=").append(this.getMajorBrand());
        stringBuilder.append(";");
        stringBuilder.append("minorVersion=").append(this.getMinorVersion());
        for (String string : this.compatibleBrands) {
            stringBuilder.append(";");
            stringBuilder.append("compatibleBrand=").append(string);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

