/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class AlbumBox
extends AbstractFullBox {
    public static final String TYPE = "albm";
    private String language;
    private String albumTitle;
    private int trackNumber;

    public AlbumBox() {
        super(TYPE);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getAlbumTitle() {
        return this.albumTitle;
    }

    public int getTrackNumber() {
        return this.trackNumber;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setAlbumTitle(String string) {
        this.albumTitle = string;
    }

    public void setTrackNumber(int n) {
        this.trackNumber = n;
    }

    @Override
    protected long getContentSize() {
        return 6 + Utf8.utf8StringLengthInBytes(this.albumTitle) + 1 + (this.trackNumber == -1 ? 0 : 1);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.language = IsoTypeReader.readIso639(byteBuffer);
        this.albumTitle = IsoTypeReader.readString(byteBuffer);
        this.trackNumber = byteBuffer.remaining() > 0 ? IsoTypeReader.readUInt8(byteBuffer) : -1;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeIso639(byteBuffer, this.language);
        byteBuffer.put(Utf8.convert(this.albumTitle));
        byteBuffer.put((byte)0);
        if (this.trackNumber != -1) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.trackNumber);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AlbumBox[language=").append(this.getLanguage()).append(";");
        stringBuilder.append("albumTitle=").append(this.getAlbumTitle());
        if (this.trackNumber >= 0) {
            stringBuilder.append(";trackNumber=").append(this.getTrackNumber());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

