/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.Utf8;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public final class IsoTypeReader {
    public static long readUInt32BE(ByteBuffer byteBuffer) {
        long l = IsoTypeReader.readUInt8(byteBuffer);
        long l2 = IsoTypeReader.readUInt8(byteBuffer);
        long l3 = IsoTypeReader.readUInt8(byteBuffer);
        long l4 = IsoTypeReader.readUInt8(byteBuffer);
        return (l4 << 24) + (l3 << 16) + (l2 << 8) + (l << 0);
    }

    public static long readUInt32(ByteBuffer byteBuffer) {
        long l = byteBuffer.getInt();
        if (l < 0L) {
            l += 0x100000000L;
        }
        return l;
    }

    public static int readUInt24(ByteBuffer byteBuffer) {
        int n = 0;
        n += IsoTypeReader.readUInt16(byteBuffer) << 8;
        return n += IsoTypeReader.byte2int(byteBuffer.get());
    }

    public static int readUInt16(ByteBuffer byteBuffer) {
        int n = 0;
        n += IsoTypeReader.byte2int(byteBuffer.get()) << 8;
        return n += IsoTypeReader.byte2int(byteBuffer.get());
    }

    public static int readUInt16BE(ByteBuffer byteBuffer) {
        int n = 0;
        n += IsoTypeReader.byte2int(byteBuffer.get());
        return n += IsoTypeReader.byte2int(byteBuffer.get()) << 8;
    }

    public static int readUInt8(ByteBuffer byteBuffer) {
        return IsoTypeReader.byte2int(byteBuffer.get());
    }

    public static int byte2int(byte n) {
        return n < 0 ? n + 256 : n;
    }

    public static String readString(ByteBuffer byteBuffer) {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((by = byteBuffer.get()) != 0) {
            byteArrayOutputStream.write(by);
        }
        return Utf8.convert(byteArrayOutputStream.toByteArray());
    }

    public static String readString(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return Utf8.convert(byArray);
    }

    public static long readUInt64(ByteBuffer byteBuffer) {
        long l = 0L;
        if ((l += IsoTypeReader.readUInt32(byteBuffer) << 32) < 0L) {
            throw new RuntimeException("I don't know how to deal with UInt64! long is not sufficient and I don't want to use BigInt");
        }
        return l += IsoTypeReader.readUInt32(byteBuffer);
    }

    public static double readFixedPoint1616(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        int n = 0;
        n |= byArray[0] << 24 & 0xFF000000;
        n |= byArray[1] << 16 & 0xFF0000;
        n |= byArray[2] << 8 & 0xFF00;
        return (double)(n |= byArray[3] & 0xFF) / 65536.0;
    }

    public static double readFixedPoint0230(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        int n = 0;
        n |= byArray[0] << 24 & 0xFF000000;
        n |= byArray[1] << 16 & 0xFF0000;
        n |= byArray[2] << 8 & 0xFF00;
        return (double)(n |= byArray[3] & 0xFF) / 1.073741824E9;
    }

    public static float readFixedPoint88(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[2];
        byteBuffer.get(byArray);
        int n = 0;
        n = (short)(n | byArray[0] << 8 & 0xFF00);
        n = (short)(n | byArray[1] & 0xFF);
        return (float)n / 256.0f;
    }

    public static String readIso639(ByteBuffer byteBuffer) {
        int n = IsoTypeReader.readUInt16(byteBuffer);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int n2 = n >> (2 - i) * 5 & 0x1F;
            stringBuilder.append((char)(n2 + 96));
        }
        return stringBuilder.toString();
    }

    public static String read4cc(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        return IsoFile.bytesToFourCC(byArray);
    }
}

