/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.appwork.utils.Regex;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.TrustALLSSLFactory;

public abstract class SocksHTTPconnection
extends HTTPConnectionImpl {
    protected Socket sockssocket = null;
    protected InputStream socksinputstream = null;
    protected OutputStream socksoutputstream = null;
    protected int httpPort;
    protected String httpHost;
    protected StringBuilder proxyRequest = null;
    protected InetSocketAddress proxyInetSocketAddress = null;

    public SocksHTTPconnection(URL uRL, HTTPProxy hTTPProxy) {
        super(uRL, hTTPProxy);
    }

    protected abstract void authenticateProxyPlain() throws IOException;

    @Override
    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        try {
            this.validateProxy();
            InetAddress[] inetAddressArray = null;
            inetAddressArray = InetAddress.getAllByName(this.proxy.getHost());
            IOException iOException = null;
            long l = System.currentTimeMillis();
            for (InetAddress object : inetAddressArray) {
                this.sockssocket = new Socket();
                this.sockssocket.setSoTimeout(this.readTimeout);
                try {
                    l = System.currentTimeMillis();
                    this.proxyInetSocketAddress = new InetSocketAddress(object, this.proxy.getPort());
                    this.sockssocket.connect(this.proxyInetSocketAddress, this.connectTimeout);
                    iOException = null;
                    break;
                }
                catch (IOException throwable) {
                    this.proxyInetSocketAddress = null;
                    try {
                        this.sockssocket.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    iOException = throwable;
                }
            }
            if (iOException != null) {
                throw new ProxyConnectException(iOException, this.proxy);
            }
            this.socksinputstream = this.sockssocket.getInputStream();
            this.socksoutputstream = this.sockssocket.getOutputStream();
            this.proxyRequest = new StringBuilder();
            AUTH aUTH = this.sayHello();
            switch (aUTH) {
                case PLAIN: {
                    this.proxyRequest.append("<-PLAIN AUTH\r\n");
                    this.authenticateProxyPlain();
                    break;
                }
                case NONE: {
                    this.proxyRequest.append("<-NONE AUTH\r\n");
                }
            }
            this.httpPort = this.httpURL.getPort();
            this.httpHost = this.httpURL.getHost();
            if (this.httpPort == -1) {
                this.httpPort = this.httpURL.getDefaultPort();
            }
            Socket socket = this.establishConnection();
            if (this.httpURL.getProtocol().startsWith("https")) {
                SSLSocket sSLSocket = null;
                try {
                    SSLSocketFactory sSLHandshakeException = TrustALLSSLFactory.getSSLFactoryTrustALL();
                    sSLSocket = (SSLSocket)sSLHandshakeException.createSocket(socket, this.httpHost, this.httpPort, true);
                    sSLSocket.startHandshake();
                }
                catch (SSLHandshakeException sSLHandshakeException) {
                    try {
                        this.sockssocket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new ProxyConnectException(sSLHandshakeException, this.proxy);
                }
                this.httpSocket = sSLSocket;
            } else {
                this.httpSocket = socket;
            }
            this.httpResponseCode = -1;
            this.requestTime = System.currentTimeMillis() - l;
            this.httpPath = new Regex(this.httpURL.toString(), "https?://.*?(/.+)").getMatch(0);
            if (this.httpPath == null) {
                this.httpPath = "/";
            }
            this.sendRequest();
        }
        catch (IOException iOException) {
            try {
                this.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (iOException instanceof HTTPProxyException) {
                throw iOException;
            }
            throw new ProxyConnectException(iOException, this.proxy);
        }
    }

    @Override
    public void disconnect() {
        super.disconnect();
        try {
            this.sockssocket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected abstract Socket establishConnection() throws IOException;

    @Override
    protected String getRequestInfo() {
        if (this.proxyRequest != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.proxy.getType().name();
            stringBuilder.append("-->" + string + ":").append(this.proxy.getHost() + ":" + this.proxy.getPort()).append("\r\n");
            if (this.proxyInetSocketAddress != null && this.proxyInetSocketAddress.getAddress() != null) {
                stringBuilder.append("-->" + string + "IP:").append(this.proxyInetSocketAddress.getAddress().getHostAddress()).append("\r\n");
            }
            stringBuilder.append("----------------CONNECTRequest(" + string + ")----------\r\n");
            stringBuilder.append(this.proxyRequest.toString());
            stringBuilder.append("------------------------------------------------\r\n");
            stringBuilder.append(super.getRequestInfo());
            return stringBuilder.toString();
        }
        return super.getRequestInfo();
    }

    protected byte[] readResponse(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = this.socksinputstream.read()) != -1; ++n2) {
            byArray[n2] = (byte)n3;
        }
        if (n2 < n) {
            throw new IOException("SocksHTTPConnection: not enough data read");
        }
        return byArray;
    }

    protected abstract AUTH sayHello() throws IOException;

    protected abstract void validateProxy() throws IOException;

    protected static enum AUTH {
        PLAIN,
        NONE;

    }
}

