/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private static final char[] BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private final int[] base64buffer = new int[3];
    private final byte[] writebuffer = new byte[4];
    private int index = 0;
    private static final byte PADDING = 61;
    private boolean endFlush = false;

    public Base64OutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void flush() throws IOException {
        if (this.index == 0 || this.endFlush) {
            this.out.flush();
            return;
        }
        if (!this.endFlush) {
            this.endFlush = true;
            this.writebuffer[2] = 61;
            this.writebuffer[3] = 61;
            switch (this.index) {
                case 1: {
                    this.writebuffer[0] = (byte)BASE64[(this.base64buffer[0] & 0xFC) >> 2];
                    this.writebuffer[1] = (byte)BASE64[(this.base64buffer[0] & 3) << 4];
                    this.out.write(this.writebuffer);
                    break;
                }
                case 2: {
                    this.writebuffer[0] = (byte)BASE64[(this.base64buffer[0] & 0xFC) >> 2];
                    this.writebuffer[1] = (byte)BASE64[(this.base64buffer[0] & 3) << 4 | (this.base64buffer[1] & 0xF0) >> 4];
                    this.writebuffer[2] = (byte)BASE64[(this.base64buffer[1] & 0xF) << 2];
                    this.out.write(this.writebuffer);
                }
            }
        }
        this.index = 0;
        this.out.flush();
    }

    @Override
    public void write(int n) throws IOException {
        this.base64buffer[this.index++] = n;
        if (this.index == 3) {
            this.writebuffer[0] = (byte)BASE64[(this.base64buffer[0] & 0xFC) >> 2];
            this.writebuffer[1] = (byte)BASE64[(this.base64buffer[0] & 3) << 4 | (this.base64buffer[1] & 0xF0) >> 4];
            this.writebuffer[2] = (byte)BASE64[(this.base64buffer[1] & 0xF) << 2 | (this.base64buffer[2] & 0xC0) >> 6];
            this.writebuffer[3] = (byte)BASE64[this.base64buffer[2] & 0x3F];
            this.out.write(this.writebuffer);
            this.index = 0;
        }
    }
}

