/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event.queue;

import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.logging.Log;

public abstract class QueueAction<T, E extends Throwable> {
    private Throwable exeption;
    private volatile boolean finished = false;
    private volatile boolean killed = false;
    private Queue.QueuePriority prio = Queue.QueuePriority.NORM;
    private Queue queue = null;
    private T result = null;
    private String callerStackTrace = null;
    private volatile boolean started = false;
    private Thread thread = null;

    public QueueAction() {
    }

    public QueueAction(Queue.QueuePriority queuePriority) {
        this.prio = queuePriority;
    }

    protected boolean allowAsync() {
        return false;
    }

    protected synchronized boolean callExceptionHandler() {
        if (this.exeption == null) {
            return true;
        }
        if (this.exeption != null && this.handleException(this.exeption)) {
            this.exeption = null;
            return true;
        }
        return false;
    }

    protected String getCallerStackTrace() {
        return this.callerStackTrace;
    }

    protected Thread getCallerThread() {
        return this.thread;
    }

    public Throwable getExeption() {
        return this.exeption;
    }

    protected Queue getQueue() {
        return this.queue;
    }

    public Queue.QueuePriority getQueuePrio() {
        return this.prio;
    }

    public T getResult() {
        return this.result;
    }

    public boolean gotKilled() {
        return this.killed;
    }

    public boolean gotStarted() {
        return this.started;
    }

    public boolean handleException(Throwable throwable) {
        Log.exception(throwable);
        return false;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void kill() {
        if (this.finished) {
            return;
        }
        this.killed = true;
        this.finished = true;
    }

    protected void postRun() {
    }

    public void reset() {
        this.exeption = null;
        this.killed = false;
        this.finished = false;
        this.callerStackTrace = null;
        this.thread = null;
        this.queue = null;
    }

    protected abstract T run() throws E;

    public void setCallerThread(Queue queue, Thread thread) {
        this.thread = thread;
        this.queue = queue;
        if (queue != null && queue.isDebug() && thread != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                stringBuilder.append(stackTraceElement.toString() + "\r\n");
            }
            this.callerStackTrace = stringBuilder.toString();
            stringBuilder = null;
        }
    }

    public void setFinished(boolean bl) {
        this.finished = bl;
    }

    public void setQueuePrio(Queue.QueuePriority queuePriority) {
        this.prio = queuePriority;
    }

    public final void start(Queue queue) throws E {
        this.queue = queue;
        this.started = true;
        try {
            this.result = this.run();
        }
        catch (Throwable throwable) {
            if (queue != null && queue.isDebug()) {
                Log.L.severe("QueueActionCallerStackTrace:\r\n" + this.callerStackTrace);
            }
            this.exeption = throwable;
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw throwable;
        }
        finally {
            try {
                this.postRun();
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
            }
        }
    }
}

