/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.encoding;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.appwork.utils.logging.Log;

public class URLDecoderFixer
extends URLDecoder {
    public static String decode(String string, String string2) throws UnsupportedEncodingException {
        boolean bl = false;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n > 500 ? n / 2 : n);
        int n2 = 0;
        if (string2.length() == 0) {
            throw new UnsupportedEncodingException("URLDecoderFixer: empty string enc parameter");
        }
        boolean bl2 = false;
        byte[] byArray = null;
        block8: while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    ++n2;
                    bl = true;
                    continue block8;
                }
                case '%': {
                    int n3 = n2;
                    try {
                        try {
                            if (byArray == null) {
                                byArray = new byte[(n - n2) / 3];
                            }
                            int n4 = 0;
                            while (n2 + 2 < n && c == '%') {
                                int n5 = Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                                if (n5 < 0) {
                                    throw new IllegalArgumentException("URLDecoderFixer: Illegal hex characters in escape (%) pattern - negative value");
                                }
                                byArray[n4++] = (byte)n5;
                                if ((n2 += 3) >= n) continue;
                                c = string.charAt(n2);
                            }
                            if (n2 < n && c == '%') {
                                throw new IllegalArgumentException("URLDecoderFixer: Incomplete trailing escape (%) pattern");
                            }
                            stringBuffer.append(new String(byArray, 0, n4, string2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("URLDecoderFixer: Illegal hex characters in escape (%) pattern - " + numberFormatException.getMessage());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        bl2 = true;
                        n2 = n3;
                        stringBuffer.append(c);
                        ++n2;
                    }
                    bl = true;
                    continue block8;
                }
            }
            stringBuffer.append(c);
            ++n2;
        }
        if (bl2) {
            Log.exception(new Exception("URLDecoderFixer: had to fix " + string));
        }
        return bl ? stringBuffer.toString() : string;
    }
}

