/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.txtresource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.appwork.txtresource.Defaults;
import org.appwork.txtresource.TranslateInterface;
import org.appwork.txtresource.TranslationHandler;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;

public class TranslationFactory {
    private static final HashMap<String, TranslateInterface> CACHE = new HashMap();
    private static String language = System.getProperty("user.language").toLowerCase();

    public static <T extends TranslateInterface> T create(Class<T> clazz) {
        return TranslationFactory.create(clazz, TranslationFactory.getDesiredLanguage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TranslateInterface> T create(Class<T> clazz, String ... stringArray) {
        HashMap<String, TranslateInterface> hashMap = CACHE;
        synchronized (hashMap) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(clazz.getName());
            for (String string : stringArray) {
                stringBuilder.append(string + ";");
            }
            String string = stringBuilder.toString();
            TranslateInterface translateInterface = CACHE.get(string);
            if (translateInterface == null) {
                translateInterface = (TranslateInterface)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new TranslationHandler(clazz, stringArray));
                CACHE.put(string, translateInterface);
            }
            return (T)translateInterface;
        }
    }

    public static ArrayList<TranslateInterface> getCachedInterfaces() {
        ArrayList<TranslateInterface> arrayList = new ArrayList<TranslateInterface>();
        for (Map.Entry<String, TranslateInterface> entry : CACHE.entrySet()) {
            arrayList.remove(entry.getValue());
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public static String getDesiredLanguage() {
        return language;
    }

    public static Locale getDesiredLocale() {
        String string = TranslationFactory.getDesiredLanguage();
        return TranslationFactory.stringToLocale(string);
    }

    public static ArrayList<String> listAvailableTranslations(final Class<? extends TranslateInterface> clazz) {
        String string = clazz.getPackage().getName().replace(".", "/");
        ArrayList<String> arrayList = new ArrayList<String>();
        Defaults defaults = clazz.getAnnotation(Defaults.class);
        if (defaults != null) {
            for (String string2 : defaults.lngs()) {
                arrayList.add(string2);
            }
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith(clazz.getSimpleName() + ".") && string.endsWith(".lng");
            }
        };
        String[] stringArray = Application.getResource(string).list(filenameFilter);
        if (stringArray != null) {
            for (String string3 : stringArray) {
                String string4 = string3.substring(clazz.getSimpleName().length() + 1, string3.length() - 4);
                arrayList.remove(string4);
                arrayList.add(string4);
            }
        }
        try {
            Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = (URL)enumeration.nextElement();
                if (uRL.getProtocol().equalsIgnoreCase("jar")) {
                    JarEntry jarEntry;
                    String string2;
                    String string5 = uRL.getPath();
                    int n = string5.lastIndexOf(33);
                    string2 = string5.substring(0, n);
                    String string6 = string5.substring(n + 2);
                    JarInputStream jarInputStream = new JarInputStream(new FileInputStream(new File(new URL(string2).toURI())));
                    while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                        String string7 = jarEntry.getName();
                        if (!string7.startsWith(string6) || !string7.endsWith(".loc")) continue;
                        String string8 = new File(string7).getName();
                        string8 = string8.substring(0, string8.length() - 4);
                        arrayList.remove(string8);
                        arrayList.add(string8);
                    }
                    continue;
                }
                stringArray = new File(uRL.toURI()).list(filenameFilter);
                if (stringArray == null) continue;
                for (String string9 : stringArray) {
                    String string10 = string9.substring(clazz.getSimpleName().length() + 1, string9.length() - 4);
                    arrayList.remove(string10);
                    arrayList.add(string10);
                }
            }
        }
        catch (Exception exception) {
            Log.exception(exception);
        }
        return arrayList;
    }

    public static String localeToString(Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(locale.getLanguage());
        String string = locale.getCountry();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.append("-");
            stringBuilder.append(locale.getCountry());
            string = locale.getVariant();
            if (string != null && string.trim().length() > 0) {
                stringBuilder.append("-");
                stringBuilder.append(locale.getCountry());
            }
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(new Locale("zh", "DE", "hans").getDisplayName());
        System.out.println(Locale.TRADITIONAL_CHINESE.getDisplayName());
    }

    public static boolean setDesiredLanguage(String string) {
        if (TranslationFactory.getDesiredLanguage().equals(string)) {
            return false;
        }
        language = string;
        for (TranslateInterface translateInterface : CACHE.values()) {
            translateInterface._getHandler().setLanguage(string);
        }
        return true;
    }

    public static Locale stringToLocale(String string) {
        String[] stringArray = string.split("[\\-\\_]");
        switch (stringArray.length) {
            case 1: {
                return new Locale(stringArray[0]);
            }
            case 2: {
                return new Locale(stringArray[0], stringArray[1]);
            }
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }
}

