/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson.mapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.appwork.utils.logging.Log;

public class Setter {
    private final String key;
    private final Method method;
    private final Type type;

    public Setter(String string, Method method) {
        this.key = string;
        this.method = method;
        method.setAccessible(true);
        this.type = method.getGenericParameterTypes()[0];
    }

    public String getKey() {
        return this.key;
    }

    public Method getMethod() {
        return this.method;
    }

    public Type getType() {
        return this.type;
    }

    public void setValue(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.type instanceof Class && ((Class)this.type).isEnum()) {
            object2 = Enum.valueOf((Class)this.type, object2 + "");
        }
        try {
            this.method.invoke(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.L.severe(this.method + " " + object2);
            throw illegalArgumentException;
        }
    }
}

