/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.DefaultByteValue;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;

public class ByteKeyHandler
extends KeyHandler<Byte> {
    private SpinnerValidator validator;
    private byte min;
    private byte max;

    public ByteKeyHandler(StorageHandler<?> storageHandler, String string) {
        super(storageHandler, string);
    }

    @Override
    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        ArrayList<Class<SpinnerValidator>> arrayList = new ArrayList<Class<SpinnerValidator>>();
        arrayList.add(SpinnerValidator.class);
        return arrayList.toArray(new Class[0]);
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultByteValue.class;
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue((byte)0);
    }

    @Override
    protected void initHandler() {
        this.validator = this.getAnnotation(SpinnerValidator.class);
        if (this.validator != null) {
            this.min = (byte)this.validator.min();
            this.max = (byte)this.validator.max();
        }
    }

    @Override
    protected void putValue(Byte by) {
        this.storageHandler.putPrimitive(this.getKey(), by);
    }

    @Override
    protected void validateValue(Byte by) throws Throwable {
        byte by2;
        if (this.validator != null && ((by2 = by.byteValue()) < this.min || by2 > this.max)) {
            throw new ValidationException();
        }
    }
}

