/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config;

import java.lang.ref.WeakReference;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.appwork.scheduler.DelayedRunnable;

public class MinTimeWeakReference<T>
extends WeakReference<T> {
    private static final ScheduledExecutorService EXECUTER = Executors.newSingleThreadScheduledExecutor();
    private T hard;
    private DelayedRunnable delayer;

    public static ScheduledExecutorService getExecuter() {
        return EXECUTER;
    }

    public static void main(String[] stringArray) {
        int n;
        MinTimeWeakReference<double[]> minTimeWeakReference = new MinTimeWeakReference<double[]>(new double[20000], 2000L, null);
        for (n = 0; n < 20; ++n) {
            System.out.println(n * 1000 + " - " + minTimeWeakReference.get().length);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        for (n = 0; n < 20; ++n) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            System.gc();
            System.out.println(n * 1000 + " - " + (minTimeWeakReference.superget() != null));
        }
    }

    public MinTimeWeakReference(T t, long l, String string) {
        super(t);
        this.hard = t;
        this.delayer = new DelayedRunnable(EXECUTER, l){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void delayedrun() {
                MinTimeWeakReference minTimeWeakReference = MinTimeWeakReference.this;
                synchronized (minTimeWeakReference) {
                    MinTimeWeakReference.this.hard = null;
                }
            }
        };
        this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object t = super.get();
        if (t == null) {
            MinTimeWeakReference minTimeWeakReference = this;
            synchronized (minTimeWeakReference) {
                if (this.delayer != null) {
                    this.delayer.stop();
                }
                this.delayer = null;
                this.hard = null;
                return null;
            }
        }
        MinTimeWeakReference minTimeWeakReference = this;
        synchronized (minTimeWeakReference) {
            if (this.delayer != null) {
                this.delayer.run();
                this.hard = t;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGone() {
        Object t = super.get();
        if (t == null) {
            MinTimeWeakReference minTimeWeakReference = this;
            synchronized (minTimeWeakReference) {
                if (this.delayer != null) {
                    this.delayer.stop();
                }
                this.delayer = null;
                this.hard = null;
            }
            return true;
        }
        return false;
    }

    public T superget() {
        return super.get();
    }
}

