/*
 * Decompiled with CFR 0.152.
 */
package jd.utils.locale;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.JDLogger;
import jd.nutils.io.JDIO;
import jd.utils.JDUtilities;
import jd.utils.locale.ConvertEntry;
import jd.utils.locale.InterfaceCache;
import jd.utils.locale.LngEntry;
import org.appwork.utils.Regex;

public class SrcParser {
    private final File root;
    private final int rootLen;
    private ArrayList<LngEntry> entries;
    private File currentFile;
    private String currentFileName;
    private String currentContent;
    private ArrayList<String> pattern = new ArrayList();

    public static void deleteCache() {
        File file = JDUtilities.getResourceFile("tmp/lfe/cache/");
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (File file2 : fileArray) {
            file2.delete();
        }
    }

    public SrcParser(File file) {
        this.root = file;
        this.rootLen = this.root.getAbsolutePath().length() + 1;
        this.entries = new ArrayList();
        this.pattern.add("sys\\.warning\\.dlcerror\\.(.+?)");
    }

    public ArrayList<LngEntry> getEntries() {
        return this.entries;
    }

    public ArrayList<String> getPattern() {
        return this.pattern;
    }

    public void parse() {
        for (File file : this.getSourceFiles(this.root)) {
            this.parseFile(file);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseFile(File file) {
        String[] stringArray;
        this.currentFile = file;
        this.currentFileName = file.getName();
        this.currentFileName = this.currentFileName.substring(0, this.currentFileName.length() - 5);
        if (this.currentFileName.equals("SrcParser")) {
            return;
        }
        this.currentContent = JDIO.readFileToString(file);
        ArrayList<LngEntry> arrayList = new ArrayList<LngEntry>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.prepareContent();
        this.currentContent = Pattern.compile("\\/\\*(.*?)\\*\\/", 32).matcher(this.currentContent).replaceAll("[[/*.....*/]]");
        this.currentContent = Pattern.compile("[^:]//(.*?)[\n|\r]", 32).matcher(this.currentContent).replaceAll("[[\\.....]]");
        this.currentContent = Pattern.compile("JDL\\s*?\\.\\s*?L", 32).matcher(this.currentContent).replaceAll("JDL.L");
        for (String string : stringArray = new Regex(this.currentContent, "([^;^{^}]*JDL\\.LF?\\s*?\\(.*?\\)[^;^{^}]*)").getColumn(0)) {
            this.parseCodeLine(string, arrayList, arrayList2);
        }
        if (this.entries.size() > 0) {
            File file2 = this.getTranslationPath(file);
            for (LngEntry lngEntry : this.entries) {
                void var8_15;
                ConvertEntry convertEntry = InterfaceCache.get(file2).getMap().get(lngEntry.getKey());
                if (convertEntry == null) {
                    ConvertEntry convertEntry2 = new ConvertEntry(lngEntry.getKey(), lngEntry.getValue());
                    InterfaceCache.get(file2).getMap().put(lngEntry.getKey(), convertEntry2);
                }
                var8_15.addFile(file);
            }
            this.entries.clear();
        }
    }

    private File getTranslationPath(File file) {
        String string = file.getPath().replace("\\", "/").substring(4);
        String[] stringArray = file.getPath().split("[\\\\/]");
        if ("captcha".equals(stringArray[2])) {
            return new File(this.root, "jd/captcha/translate");
        }
        if (string.startsWith("jd/controlling/reconnect/plugins/")) {
            return new File(this.root, "jd/controlling/reconnect/plugins/" + stringArray[5] + "/translate");
        }
        if (string.startsWith("jd/gui/") || string.startsWith("org/jdownloader/gui/")) {
            return new File(this.root, "org/jdownloader/gui/translate");
        }
        if (string.startsWith("jd/plugins/decrypter/")) {
            return file;
        }
        if (string.startsWith("jd/plugins/hoster/")) {
            return file;
        }
        if (string.startsWith("org/jdownloader/extensions/") && stringArray.length >= 6) {
            return new File(this.root, "org/jdownloader/extensions/" + stringArray[4] + "/translate");
        }
        return new File(this.root, "org/jdownloader/translate");
    }

    private void prepareContent() {
        String string = this.currentFile.getAbsolutePath();
        string = string.replace("\\", "/");
        string = string.substring(string.indexOf("/jd/") + 1).replace('/', '.');
        string = string.replace(".java", "");
        this.currentContent = this.currentContent.replace("this.getClass().getName()", "\"" + string + "\"");
        this.currentContent = this.currentContent.replace("getClass().getName()", "\"" + string + "\"");
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        this.currentContent = this.currentContent.replace("this.getClass().getSimpleName()", "\"" + string2 + "\"");
        this.currentContent = this.currentContent.replace("getClass().getSimpleName()", "\"" + string2 + "\"");
        this.currentContent = this.currentContent.replace("\"+\"", "");
    }

    private ArrayList<File> getSourceFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file != null) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    arrayList.addAll(this.getSourceFiles(file2));
                    continue;
                }
                if (!file2.getName().toLowerCase().endsWith(".java")) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    private void parseCodeLine(String string, ArrayList<LngEntry> arrayList, ArrayList<String> arrayList2) {
        String[] stringArray = string.split("JDL\\.");
        String string2 = "\"(.*?)(?<!\\\\)\"";
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        block18: for (int i = 0; i < n; ++i) {
            LngEntry lngEntry;
            String string3;
            int n2;
            int n3;
            String string4;
            String string5 = string4 = stringArray2[i];
            if (!(string5 = string5.trim()).startsWith("L")) continue;
            String[] stringArray3 = new Regex(string5, string2).getColumn(0);
            string5 = string5.replace("\r", "");
            string5 = string5.replace("\n", "");
            string5 = string5.replaceAll(string2, "%%%S%%%");
            string4 = string5 = string5.replace(" ", "");
            try {
                int n4 = string5.indexOf(",");
                n3 = string5.indexOf(")", n4 + 1);
                n2 = string5.indexOf(",", n4 + 1);
                if (n2 > 0 && n2 < n3) {
                    n3 = n2;
                }
                string5 = n3 < 0 ? string5.substring(string5.indexOf("(") + 1).trim() : string5.substring(string5.indexOf("(") + 1, n3).trim();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            while (string5.length() > 0 && string5.charAt(string5.length() - 1) == ',') {
                string5 = string5.substring(0, string5.length() - 1);
            }
            if (string5 == null || string5.length() == 0) continue;
            string5 = string5.replace("%%%+%%%", "%%%%%%");
            String[] stringArray4 = string5.split(",");
            if (string4.startsWith("LF ") || string4.startsWith("LF(")) {
                if (string4.substring(2).trim().charAt(0) != '(') {
                    JDLogger.getLogger().severe("Malformated translation value in " + this.currentFile + " : " + string5);
                    continue;
                }
                if (stringArray4.length != 2) {
                    JDLogger.getLogger().severe("Malformated translation pair (inner functions?) in " + this.currentFile + " : " + string);
                    continue;
                }
                n3 = 0;
                if (stringArray4[1].contains("+")) {
                    JDLogger.getLogger().severe("Malformated translation value in " + this.currentFile + " : " + string);
                    continue;
                }
                while (stringArray4[0].contains("+")) {
                    String[][] stringArray5;
                    try {
                        for (String[] stringArray6 : stringArray5 = new Regex(stringArray4[0], "(\\+([^%]+)\\+?)").getMatches()) {
                            try {
                                string3 = this.getValueOf(stringArray6[1]);
                                stringArray4[0] = stringArray4[0].replace(stringArray6[0], string3);
                            }
                            catch (Exception exception) {
                                JDLogger.getLogger().severe("LF1 Malformated translation key in " + this.currentFile + " : " + string);
                                break block18;
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break;
                    }
                    try {
                        for (String[] stringArray6 : stringArray5 = new Regex(stringArray4[0], "(\\+?([^%]+)\\+)").getMatches()) {
                            try {
                                string3 = this.getValueOf(stringArray6[1]);
                                stringArray4[0] = stringArray4[0].replace(stringArray6[0], string3);
                            }
                            catch (Exception exception) {
                                JDLogger.getLogger().severe("LF2 Malformated translation key in " + this.currentFile + " : " + string);
                                break block18;
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break;
                    }
                }
                for (n2 = 0; n2 < stringArray4.length; ++n2) {
                    while (stringArray4[n2].contains("%%%S%%%")) {
                        stringArray4[n2] = stringArray4[n2].replaceFirst("%%%S%%%", Matcher.quoteReplacement(stringArray3[n3++]));
                    }
                }
                String string6 = new Regex(stringArray4[0], "([\\(\\)\\{\\}\\/\\\\\\$\\&\\+\\~\\#\\\"\\!\\?]+)").getMatch(0);
                if (string6 != null) {
                    int n5 = stringArray4[0].indexOf(string6);
                    if (n5 >= 0) {
                        JDLogger.getLogger().warning("Unsupported chars (" + stringArray4[0].substring(0, n5) + "<< |" + stringArray4[0].substring(n5 + 1) + ") in key:" + this.currentFile + " : " + stringArray4[0]);
                        continue;
                    }
                    JDLogger.getLogger().warning("Unsupported chars in key: " + this.currentFile + " : " + stringArray4[0]);
                    continue;
                }
                if (!stringArray4[0].contains(".")) {
                    JDLogger.getLogger().warning("Prob. Malformated translation key in " + this.currentFile + " : " + string);
                }
                if (stringArray4[0].contains("null")) {
                    JDLogger.getLogger().warning("Prob. Malformated translation key in " + this.currentFile + " : " + string);
                }
                if (!this.entries.contains(lngEntry = new LngEntry(stringArray4[0], stringArray4[1]))) {
                    this.entries.add(lngEntry);
                }
                if (arrayList.contains(lngEntry)) continue;
                arrayList.add(lngEntry);
                continue;
            }
            if (!string4.startsWith("L ") && !string4.startsWith("L(")) continue;
            if (string4.substring(1).trim().charAt(0) != '(') {
                JDLogger.getLogger().severe("Malformated translation value in " + this.currentFile + " : " + string5);
                continue;
            }
            if (stringArray4.length != 2) {
                JDLogger.getLogger().severe("Malformated translation pair (inner functions?) in " + this.currentFile + " : " + string);
                continue;
            }
            n3 = 0;
            if (stringArray4[1].contains("+")) {
                JDLogger.getLogger().severe("Malformated translation value in " + this.currentFile + " : " + string);
                continue;
            }
            while (stringArray4[0].contains("+")) {
                String[][] stringArray7;
                try {
                    for (String[] stringArray6 : stringArray7 = new Regex(stringArray4[0], "(\\+([^%]+)\\+?)").getMatches()) {
                        try {
                            string3 = this.getValueOf(stringArray6[1]);
                            stringArray4[0] = stringArray4[0].replace(stringArray6[0], string3);
                        }
                        catch (Exception exception) {
                            JDLogger.getLogger().severe("L1 Malformated translation key in " + this.currentFile + " : " + string);
                            stringArray4[0] = stringArray4[0].replace(stringArray6[0], "*");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break;
                }
                try {
                    for (String[] stringArray6 : stringArray7 = new Regex(stringArray4[0], "(\\+?([^%]+)\\+)").getMatches()) {
                        try {
                            string3 = this.getValueOf(stringArray6[1]);
                            stringArray4[0] = stringArray4[0].replace(stringArray6[0], string3);
                        }
                        catch (Exception exception) {
                            JDLogger.getLogger().severe("L2 Malformated translation key in " + this.currentFile + " : " + string);
                            break block18;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break;
                }
            }
            for (n2 = 0; n2 < stringArray4.length; ++n2) {
                while (stringArray4[n2].contains("%%%S%%%")) {
                    stringArray4[n2] = stringArray4[n2].replaceFirst("%%%S%%%", Matcher.quoteReplacement(stringArray3[n3++]));
                }
            }
            String string7 = new Regex(stringArray4[0], "([\\(\\)\\{\\}\\/\\\\\\$\\&\\+\\~\\#\\\"\\!\\?]+)").getMatch(0);
            if (string7 != null) {
                int n6 = stringArray4[0].indexOf(string7);
                if (n6 >= 0) {
                    JDLogger.getLogger().warning("Unsupported chars (" + stringArray4[0].substring(0, n6) + "<< |" + stringArray4[0].substring(n6 + 1) + ") in key:" + this.currentFile + " : " + stringArray4[0]);
                    continue;
                }
                JDLogger.getLogger().warning("Unsupported chars in key: " + this.currentFile + " : " + stringArray4[0]);
                continue;
            }
            if (!stringArray4[0].contains(".")) {
                JDLogger.getLogger().warning("Prob. Malformated translation key in " + this.currentFile + " : " + string);
                break;
            }
            if (stringArray4[0].contains("null")) {
                JDLogger.getLogger().warning("Prob. Malformated translation key in " + this.currentFile + " : " + string);
                break;
            }
            if (stringArray4[0].contains("*")) {
                if (this.currentFile.getName().contains("ToolBarAction")) continue;
                String string8 = stringArray4[0].replace(".", "\\.").replace("*", "(.+?)");
                JDLogger.getLogger().severe("Pattern match in " + this.currentFile + " : " + string);
                if (!this.pattern.contains(string8)) {
                    this.pattern.add(string8);
                }
                if (arrayList2.contains(string8)) continue;
                arrayList2.add(string8);
                continue;
            }
            lngEntry = new LngEntry(stringArray4[0], stringArray4[1]);
            if (!this.entries.contains(lngEntry)) {
                this.entries.add(lngEntry);
            }
            if (arrayList.contains(lngEntry)) continue;
            arrayList.add(lngEntry);
        }
    }

    private String getValueOf(String string) {
        string = string.replace(this.currentFileName + ".", "");
        String[] stringArray = new Regex(this.currentContent, string + "\\s*=(.*?);").getColumn(0);
        String string2 = stringArray[stringArray.length - 1].trim();
        while (string2.startsWith("\"")) {
            string2 = string2.substring(1);
        }
        while (string2.endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }
}

